/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.cache.redisson.autoconfigure;

import cn.herodotus.stirrup.cache.redisson.annotation.ConditionalOnRedissonEnabled;
import cn.herodotus.stirrup.cache.redisson.properties.RedissonProperties;
import cn.herodotus.stirrup.core.foundation.utils.ResourceUtils;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnRedissonEnabled
@EnableConfigurationProperties(value={RedissonProperties.class})
public class CacheRedissonAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CacheRedissonAutoConfiguration.class);
    private final RedissonProperties redissonProperties;
    private final RedisProperties redisProperties;

    public CacheRedissonAutoConfiguration(RedissonProperties redissonProperties, RedisProperties redisProperties) {
        this.redissonProperties = redissonProperties;
        this.redisProperties = redisProperties;
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Starter [Cache Redisson] Configure.");
    }

    private File readConfigFile() {
        String configFile = this.redissonProperties.getConfig();
        if (StringUtils.isNotBlank((CharSequence)configFile)) {
            try {
                return ResourceUtils.getFile((String)configFile);
            }
            catch (IOException e) {
                log.error("[Herodotus] |- Can not found the config file [{}], check whether the format is correct.", (Object)configFile);
            }
        }
        return null;
    }

    private Config getConfigByFile() {
        try {
            File configFile = this.readConfigFile();
            if (ObjectUtils.isNotEmpty((Object)configFile) && StringUtils.endsWithIgnoreCase((CharSequence)configFile.getName(), (CharSequence)".yaml")) {
                return Config.fromYAML((File)configFile);
            }
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Redisson loading the config file error!");
        }
        return null;
    }

    private Config getDefaultConfig() {
        Config config = new Config();
        switch (this.redissonProperties.getMode()) {
            case CLUSTER: {
                ClusterServersConfig clusterServersConfig = config.useClusterServers();
                ClusterServersConfig redissonClusterConfig = this.redissonProperties.getClusterServersConfig();
                if (ObjectUtils.isNotEmpty((Object)redissonClusterConfig)) {
                    BeanUtils.copyProperties((Object)redissonClusterConfig, (Object)clusterServersConfig, ClusterServersConfig.class);
                    clusterServersConfig.setNodeAddresses(redissonClusterConfig.getNodeAddresses());
                }
                if (CollectionUtils.isEmpty((Collection)clusterServersConfig.getNodeAddresses())) {
                    List nodes = this.redisProperties.getCluster().getNodes();
                    nodes.stream().map(a -> this.redissonProperties.getProtocol() + a).forEach(xva$0 -> clusterServersConfig.addNodeAddress(new String[]{xva$0}));
                }
                if (!StringUtils.isBlank((CharSequence)clusterServersConfig.getPassword()) || !StringUtils.isNotBlank((CharSequence)this.redisProperties.getPassword())) break;
                clusterServersConfig.setPassword(this.redisProperties.getPassword());
                break;
            }
            case SENTINEL: {
                SentinelServersConfig sentinelServersConfig = config.useSentinelServers();
                SentinelServersConfig redissonSentinelConfig = this.redissonProperties.getSentinelServersConfig();
                if (ObjectUtils.isNotEmpty((Object)redissonSentinelConfig)) {
                    BeanUtils.copyProperties((Object)redissonSentinelConfig, (Object)sentinelServersConfig, SentinelServersConfig.class);
                    sentinelServersConfig.setSentinelAddresses(redissonSentinelConfig.getSentinelAddresses());
                }
                if (CollectionUtils.isEmpty((Collection)sentinelServersConfig.getSentinelAddresses())) {
                    List nodes = this.redisProperties.getSentinel().getNodes();
                    nodes.stream().map(a -> this.redissonProperties.getProtocol() + a).forEach(xva$0 -> sentinelServersConfig.addSentinelAddress(new String[]{xva$0}));
                }
                if (StringUtils.isBlank((CharSequence)sentinelServersConfig.getPassword()) && StringUtils.isNotBlank((CharSequence)this.redisProperties.getPassword())) {
                    sentinelServersConfig.setPassword(this.redisProperties.getPassword());
                }
                if (!StringUtils.isBlank((CharSequence)sentinelServersConfig.getMasterName())) break;
                sentinelServersConfig.setMasterName(this.redisProperties.getSentinel().getMaster());
                break;
            }
            default: {
                SingleServerConfig singleServerConfig = config.useSingleServer();
                if (ObjectUtils.isNotEmpty((Object)this.redissonProperties.getSingleServerConfig())) {
                    BeanUtils.copyProperties((Object)this.redissonProperties.getSingleServerConfig(), (Object)singleServerConfig, SingleServerConfig.class);
                }
                if (StringUtils.isBlank((CharSequence)singleServerConfig.getAddress())) {
                    singleServerConfig.setAddress(this.redissonProperties.getProtocol() + this.redisProperties.getHost() + ":" + this.redisProperties.getPort());
                }
                if (StringUtils.isBlank((CharSequence)singleServerConfig.getPassword()) && StringUtils.isNotBlank((CharSequence)this.redisProperties.getPassword())) {
                    singleServerConfig.setPassword(this.redisProperties.getPassword());
                }
                singleServerConfig.setDatabase(this.redisProperties.getDatabase());
            }
        }
        config.setCodec((Codec)new JsonJacksonCodec());
        config.setLockWatchdogTimeout(30000L);
        return config;
    }

    @Bean
    public RedissonClient redissonClient() {
        Config config = this.getConfigByFile();
        if (ObjectUtils.isEmpty((Object)config)) {
            config = this.getDefaultConfig();
        }
        RedissonClient redissonClient = Redisson.create((Config)config);
        log.trace("[Herodotus] |- Bean [Redisson Client] Auto Configure.");
        return redissonClient;
    }
}

