/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.assistant.ip2region.searcher;

import cn.herodotus.stirrup.assistant.ip2region.definition.Ip2RegionSearcher;
import cn.herodotus.stirrup.assistant.ip2region.domain.IpLocation;
import cn.herodotus.stirrup.assistant.ip2region.exception.SearchIpLocationException;
import cn.herodotus.stirrup.assistant.ip2region.searcher.IpV4Searcher;
import cn.herodotus.stirrup.assistant.ip2region.searcher.IpV6Searcher;
import cn.herodotus.stirrup.assistant.ip2region.utils.IpLocationUtils;
import cn.herodotus.stirrup.core.foundation.utils.ResourceUtils;
import java.io.IOException;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class DefaultIp2RegionSearcher
implements Ip2RegionSearcher,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultIp2RegionSearcher.class);
    private IpV4Searcher ipV4Searcher;
    private IpV6Searcher ipV6Searcher;
    private final String ipV4Resource;
    private final String ipV6Resource;

    public DefaultIp2RegionSearcher(String ipV4Resource, String ipV6Resource) {
        this.ipV4Resource = ipV4Resource;
        this.ipV6Resource = ipV6Resource;
    }

    private byte[] toBytes(String location) throws IllegalAccessException {
        Resource resource = ResourceUtils.getResource((String)location);
        if (ObjectUtils.isNotEmpty((Object)resource)) {
            log.debug("[Herodotus] |- Load ip region database [{}]", (Object)resource.getFilename());
            return ResourceUtils.toBytes((Resource)resource);
        }
        log.error("[Herodotus] |- Cannot read ip region database in resources folder!");
        throw new IllegalAccessException("Cannot read ip region database in resources folder");
    }

    public void afterPropertiesSet() throws Exception {
        byte[] ipV6Database;
        byte[] ipV4Database = this.toBytes(this.ipV4Resource);
        if (ObjectUtils.isNotEmpty((Object)ipV4Database)) {
            this.ipV4Searcher = IpV4Searcher.newWithBuffer(ipV4Database);
        }
        if (ObjectUtils.isNotEmpty((Object)(ipV6Database = this.toBytes(this.ipV6Resource)))) {
            this.ipV6Searcher = new IpV6Searcher(ipV6Database);
        }
    }

    @Override
    public IpLocation memorySearch(long ip) {
        try {
            return IpLocationUtils.toIpV4Location(this.ipV4Searcher.search(ip));
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Search ip v4 location catch io exception!", (Throwable)e);
            throw new SearchIpLocationException(e);
        }
    }

    @Override
    public IpLocation memorySearch(String ip) {
        String[] ipV4Part = IpLocationUtils.getIpV4Part(ip);
        if (ipV4Part.length == 4) {
            return this.memorySearch(IpV4Searcher.getIpAdder(ipV4Part));
        }
        if (!ip.contains(":")) {
            throw new IllegalArgumentException("invalid ip location [" + ip + "]");
        }
        return this.ipV6Searcher.query(ip);
    }

    public void destroy() throws Exception {
        if (ObjectUtils.isNotEmpty((Object)this.ipV4Searcher)) {
            this.ipV4Searcher.close();
        }
    }
}

