/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.assistant.ip2region.config;

import cn.herodotus.stirrup.assistant.ip2region.definition.Ip2RegionSearcher;
import cn.herodotus.stirrup.assistant.ip2region.properties.Ip2RegionProperties;
import cn.herodotus.stirrup.assistant.ip2region.searcher.DefaultIp2RegionSearcher;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={Ip2RegionProperties.class})
public class Ip2RegionConfiguration {
    private static final Logger log = LoggerFactory.getLogger(Ip2RegionConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [Ip2Region] Configure.");
    }

    @Bean
    public Ip2RegionSearcher defaultIp2RegionSearcher(Ip2RegionProperties ip2RegionProperties) {
        DefaultIp2RegionSearcher searcher = new DefaultIp2RegionSearcher(ip2RegionProperties.getIpV4Resource(), ip2RegionProperties.getIpV6Resource());
        log.trace("[Herodotus] |- Bean [Ip2Region Searcher] Configure.");
        return searcher;
    }
}

