/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.assistant.ip2region.utils;

import cn.herodotus.stirrup.assistant.ip2region.domain.IpLocation;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class IpLocationUtils {
    private static String check(String element) {
        if (StringUtils.isBlank((CharSequence)element) || StringUtils.equals((CharSequence)element, (CharSequence)"0")) {
            return null;
        }
        return element;
    }

    private static IpLocation toIpLocation(String region, String separator, int cover, String isp) {
        Assert.notNull((Object)region, (String)"The region is required.");
        String[] informations = StringUtils.split((String)region, (String)separator);
        if (informations.length < cover) {
            informations = Arrays.copyOf(informations, cover);
        }
        IpLocation location = new IpLocation();
        location.setCountry(IpLocationUtils.check(informations[0]));
        location.setProvince(IpLocationUtils.check(informations[1]));
        location.setCity(IpLocationUtils.check(informations[2]));
        location.setRegion(IpLocationUtils.check(informations[3]));
        location.setIsp(IpLocationUtils.check(isp));
        return location;
    }

    public static IpLocation toIpV4Location(String region) {
        return IpLocationUtils.toIpLocation(region, "|", 5, null);
    }

    public static IpLocation toIpV6Location(String region, String isp) {
        return IpLocationUtils.toIpLocation(region, "t", 4, isp);
    }

    public static IpLocation toIpV6Location(String[] record) {
        return IpLocationUtils.toIpV6Location(record[0], record[1]);
    }

    public static String[] getIpV4Part(String ip) {
        return StringUtils.split((String)ip, (String)".");
    }
}

