/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.assistant.ip2region.domain;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class IpLocation
implements Serializable {
    private String country;
    private String region;
    private String province;
    private String city;
    private String isp;

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getIsp() {
        return this.isp;
    }

    public void setIsp(String isp) {
        this.isp = isp;
    }

    public String getLocation() {
        return this.createLocation(false, "");
    }

    public String getLocationWithIsp() {
        return this.createLocation(true, " ");
    }

    private String createLocation(boolean withIsp, String separator) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add(this.country);
        result.add(this.region);
        result.add(this.province);
        result.add(this.city);
        if (withIsp) {
            result.add(this.isp);
        }
        result.removeIf(Objects::isNull);
        return StringUtils.join(result, (String)separator);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("country", (Object)this.country).add("region", (Object)this.region).add("province", (Object)this.province).add("city", (Object)this.city).add("isp", (Object)this.isp).toString();
    }
}

