/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.access.wxapp.processor;

import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import cn.herodotus.stirrup.access.core.definition.AccessHandler;
import cn.herodotus.stirrup.access.core.definition.AccessResponse;
import cn.herodotus.stirrup.access.core.definition.AccessUserDetails;
import cn.herodotus.stirrup.access.core.exception.AccessPreProcessFailedException;
import cn.herodotus.stirrup.access.wxapp.processor.WxappProcessor;
import cn.herodotus.stirrup.core.foundation.enums.AccountCategory;
import cn.herodotus.stirrup.core.identity.domain.AccessPrincipal;
import cn.herodotus.stirrup.core.identity.exception.AccessIdentityVerificationFailedException;
import org.apache.commons.lang3.ObjectUtils;

public class WxappAccessHandler
implements AccessHandler {
    private final WxappProcessor wxappProcessor;

    public WxappAccessHandler(WxappProcessor wxappProcessor) {
        this.wxappProcessor = wxappProcessor;
    }

    public AccessResponse preProcess(String core, String ... params) {
        WxMaJscode2SessionResult wxMaSession = this.wxappProcessor.login(core, params[0]);
        if (ObjectUtils.isNotEmpty((Object)wxMaSession)) {
            AccessResponse accessResponse = new AccessResponse();
            accessResponse.setSession(wxMaSession);
            return accessResponse;
        }
        throw new AccessPreProcessFailedException("Wxapp login failed");
    }

    public AccessUserDetails loadUserDetails(String source, AccessPrincipal accessPrincipal) {
        WxMaUserInfo wxMaUserInfo = this.wxappProcessor.getUserInfo(accessPrincipal.getAppId(), accessPrincipal.getSessionKey(), accessPrincipal.getEncryptedData(), accessPrincipal.getIv());
        if (ObjectUtils.isNotEmpty((Object)wxMaUserInfo)) {
            return this.convertWxMaUserInfoToAccessUserDetails(wxMaUserInfo, accessPrincipal);
        }
        throw new AccessIdentityVerificationFailedException("Can not find the userinfo from Wechat!");
    }

    private AccessUserDetails convertWxMaUserInfoToAccessUserDetails(WxMaUserInfo wxMaUserInfo, AccessPrincipal accessPrincipal) {
        AccessUserDetails accessUserDetails = new AccessUserDetails();
        accessUserDetails.setUuid(accessPrincipal.getOpenId());
        accessUserDetails.setUsername(wxMaUserInfo.getNickName());
        accessUserDetails.setNickname(wxMaUserInfo.getNickName());
        accessUserDetails.setAvatar(wxMaUserInfo.getAvatarUrl());
        accessUserDetails.setLocation(wxMaUserInfo.getCountry() + "/" + wxMaUserInfo.getProvince() + "/" + wxMaUserInfo.getCity());
        accessUserDetails.setSource(AccountCategory.WXAPP.name());
        accessUserDetails.setOpenId(accessPrincipal.getOpenId());
        accessUserDetails.setUnionId(accessPrincipal.getUnionId());
        accessUserDetails.setAppId(wxMaUserInfo.getWatermark().getAppid());
        accessUserDetails.setPhoneNumber(wxMaUserInfo.getWatermark().getAppid());
        return accessUserDetails;
    }
}

