/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.access.wxapp.config;

import cn.herodotus.stirrup.access.wxapp.annotation.ConditionalOnWxappEnabled;
import cn.herodotus.stirrup.access.wxapp.processor.WxappAccessHandler;
import cn.herodotus.stirrup.access.wxapp.processor.WxappLogHandler;
import cn.herodotus.stirrup.access.wxapp.processor.WxappProcessor;
import cn.herodotus.stirrup.access.wxapp.properties.WxappProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWxappEnabled
@EnableConfigurationProperties(value={WxappProperties.class})
public class AccessWxappConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AccessWxappConfiguration.class);

    @PostConstruct
    public void init() {
        log.debug("[Herodotus] |- Module [Access Wxapp] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public WxappProcessor wxappProcessor(WxappProperties wxappProperties) {
        WxappProcessor wxappProcessor = new WxappProcessor();
        wxappProcessor.setWxappProperties(wxappProperties);
        wxappProcessor.setWxappLogHandler(new WxappLogHandler());
        log.trace("[Herodotus] |- Bean [Wxapp Processor] Configure.");
        return wxappProcessor;
    }

    @Bean(value={"WECHAT_MINI_APP"})
    @ConditionalOnBean(value={WxappProcessor.class})
    @ConditionalOnMissingBean
    public WxappAccessHandler wxappAccessHandler(WxappProcessor wxappProcessor) {
        WxappAccessHandler wxappAccessHandler = new WxappAccessHandler(wxappProcessor);
        log.debug("[Herodotus] |- Bean [Wxapp Access Handler] Configure.");
        return wxappAccessHandler;
    }
}

