/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.access.sms.config;

import cn.herodotus.stirrup.access.sms.annotation.ConditionalOnSmsEnabled;
import cn.herodotus.stirrup.access.sms.processor.PhoneNumberAccessHandler;
import cn.herodotus.stirrup.access.sms.properties.SmsProperties;
import cn.herodotus.stirrup.access.sms.stamp.VerificationCodeStampManager;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSmsEnabled
@EnableConfigurationProperties(value={SmsProperties.class})
public class AccessSmsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AccessSmsConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [Access SMS] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public VerificationCodeStampManager verificationCodeStampManager(SmsProperties smsProperties) {
        VerificationCodeStampManager verificationCodeStampManager = new VerificationCodeStampManager();
        verificationCodeStampManager.setSmsProperties(smsProperties);
        log.trace("[Herodotus] |- Bean [Verification Code Stamp Manager] Configure.");
        return verificationCodeStampManager;
    }

    @Bean(value={"PHONE_NUMBER"})
    public PhoneNumberAccessHandler phoneNumberAccessHandler(VerificationCodeStampManager verificationCodeStampManager) {
        PhoneNumberAccessHandler phoneNumberAuthenticationHandler = new PhoneNumberAccessHandler(verificationCodeStampManager);
        log.trace("[Herodotus] |- Bean [Phone Number SignIn Handler] Configure.");
        return phoneNumberAuthenticationHandler;
    }
}

