/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.service;

import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.s3.logic.definition.service.BaseS3ClientService;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectLegalHoldRequest;
import com.amazonaws.services.s3.model.GetObjectLegalHoldResult;
import com.amazonaws.services.s3.model.SetObjectLegalHoldRequest;
import com.amazonaws.services.s3.model.SetObjectLegalHoldResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3ObjectLegalHoldService
extends BaseS3ClientService {
    private static final Logger log = LoggerFactory.getLogger(S3ObjectLegalHoldService.class);

    public S3ObjectLegalHoldService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public GetObjectLegalHoldResult getObjectLegalHold(GetObjectLegalHoldRequest request) {
        String function = "getObjectLegalHold";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            GetObjectLegalHoldResult getObjectLegalHoldResult = amazonS3.getObjectLegalHold(request);
            return getObjectLegalHoldResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public SetObjectLegalHoldResult setObjectLegalHold(SetObjectLegalHoldRequest request) {
        String function = "setObjectLegalHold";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            SetObjectLegalHoldResult setObjectLegalHoldResult = amazonS3.setObjectLegalHold(request);
            return setObjectLegalHoldResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

