/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.service;

import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.s3.logic.definition.service.BaseS3ClientService;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3BucketVersioningConfigurationService
extends BaseS3ClientService {
    private static final Logger log = LoggerFactory.getLogger(S3BucketVersioningConfigurationService.class);

    public S3BucketVersioningConfigurationService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public BucketVersioningConfiguration getBucketVersioningConfiguration(GetBucketVersioningConfigurationRequest request) {
        String function = "getBucketVersioningConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            BucketVersioningConfiguration bucketVersioningConfiguration = amazonS3.getBucketVersioningConfiguration(request);
            return bucketVersioningConfiguration;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public void setBucketVersioningConfiguration(SetBucketVersioningConfigurationRequest request) {
        String function = "setBucketVersioningConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            amazonS3.setBucketVersioningConfiguration(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

