/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.service;

import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.s3.logic.definition.service.BaseS3ClientService;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteBucketRequest;
import com.amazonaws.services.s3.model.GetBucketLocationRequest;
import com.amazonaws.services.s3.model.HeadBucketRequest;
import com.amazonaws.services.s3.model.HeadBucketResult;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.VersionListing;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3BucketService
extends BaseS3ClientService {
    private static final Logger log = LoggerFactory.getLogger(S3BucketService.class);

    public S3BucketService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public VersionListing listVersions(ListVersionsRequest request) {
        String function = "listVersions";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            VersionListing versionListing = amazonS3.listVersions(request);
            return versionListing;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public boolean doesBucketExist(String bucketName) {
        String function = "doesBucketExistV2";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            boolean bl = amazonS3.doesBucketExistV2(bucketName);
            return bl;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public HeadBucketResult headBucket(HeadBucketRequest request) {
        String function = "headBucket";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            HeadBucketResult headBucketResult = amazonS3.headBucket(request);
            return headBucketResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public List<Bucket> listBuckets() {
        String function = "listBuckets";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            List list = amazonS3.listBuckets();
            return list;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public void deleteBucket(DeleteBucketRequest request) {
        String function = "deleteBucket";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            amazonS3.deleteBucket(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public String getBucketLocation(GetBucketLocationRequest request) {
        String function = "getBucketLocation";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            String string = amazonS3.getBucketLocation(request);
            return string;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public Bucket createBucket(CreateBucketRequest request) {
        String function = "createBucket";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            Bucket bucket = amazonS3.createBucket(request);
            return bucket;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

