/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.service;

import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.s3.logic.definition.service.BaseS3ClientService;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3BucketNotificationConfigurationService
extends BaseS3ClientService {
    private static final Logger log = LoggerFactory.getLogger(S3BucketNotificationConfigurationService.class);

    public S3BucketNotificationConfigurationService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public BucketNotificationConfiguration getBucketNotificationConfiguration(GetBucketNotificationConfigurationRequest request) {
        String function = "getBucketNotificationConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            BucketNotificationConfiguration bucketNotificationConfiguration = amazonS3.getBucketNotificationConfiguration(request);
            return bucketNotificationConfiguration;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public void setBucketNotificationConfiguration(SetBucketNotificationConfigurationRequest request) {
        String function = "setBucketNotificationConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            amazonS3.setBucketNotificationConfiguration(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

