/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.service;

import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.s3.logic.definition.service.BaseS3ClientService;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteBucketMetricsConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketMetricsConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketMetricsConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketMetricsConfigurationResult;
import com.amazonaws.services.s3.model.ListBucketMetricsConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketMetricsConfigurationsResult;
import com.amazonaws.services.s3.model.SetBucketMetricsConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketMetricsConfigurationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3BucketMetricsConfigurationService
extends BaseS3ClientService {
    private static final Logger log = LoggerFactory.getLogger(S3BucketMetricsConfigurationService.class);

    public S3BucketMetricsConfigurationService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public DeleteBucketMetricsConfigurationResult deleteBucketMetricsConfiguration(DeleteBucketMetricsConfigurationRequest request) {
        String function = "deleteBucketMetricsConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            DeleteBucketMetricsConfigurationResult deleteBucketMetricsConfigurationResult = amazonS3.deleteBucketMetricsConfiguration(request);
            return deleteBucketMetricsConfigurationResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public GetBucketMetricsConfigurationResult getBucketMetricsConfiguration(GetBucketMetricsConfigurationRequest request) {
        String function = "getBucketMetricsConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            GetBucketMetricsConfigurationResult getBucketMetricsConfigurationResult = amazonS3.getBucketMetricsConfiguration(request);
            return getBucketMetricsConfigurationResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public ListBucketMetricsConfigurationsResult listBucketMetricsConfigurations(ListBucketMetricsConfigurationsRequest request) {
        String function = "listBucketMetricsConfigurations";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            ListBucketMetricsConfigurationsResult listBucketMetricsConfigurationsResult = amazonS3.listBucketMetricsConfigurations(request);
            return listBucketMetricsConfigurationsResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public SetBucketMetricsConfigurationResult setBucketLoggingConfiguration(SetBucketMetricsConfigurationRequest request) {
        String function = "setBucketLoggingConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            SetBucketMetricsConfigurationResult setBucketMetricsConfigurationResult = amazonS3.setBucketMetricsConfiguration(request);
            return setBucketMetricsConfigurationResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

