/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.configuration;

import cn.herodotus.oss.s3.logic.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientPooledObjectFactory;
import cn.herodotus.oss.s3.logic.properties.S3Properties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class S3ClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(S3ClientConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [S3 Client] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public S3ClientObjectPool s3ClientObjectPool(S3Properties s3Properties) {
        S3ClientPooledObjectFactory factory = new S3ClientPooledObjectFactory(s3Properties);
        S3ClientObjectPool pool = new S3ClientObjectPool(factory);
        log.trace("[Herodotus] |- Bean [S3 Client Pool] Auto Configure.");
        return pool;
    }
}

