/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.service;

import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.s3.logic.definition.service.BaseS3ClientService;
import cn.herodotus.oss.s3.logic.service.S3BucketAccessControlListService;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.PresignedUrlDownloadRequest;
import com.amazonaws.services.s3.model.PresignedUrlDownloadResult;
import com.amazonaws.services.s3.model.PresignedUrlUploadRequest;
import com.amazonaws.services.s3.model.PresignedUrlUploadResult;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3PresignedUrlService
extends BaseS3ClientService {
    private static final Logger log = LoggerFactory.getLogger(S3BucketAccessControlListService.class);

    public S3PresignedUrlService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public URL generatePresignedUrl(GeneratePresignedUrlRequest request) {
        String function = "generatePresignedUrl";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            URL uRL = amazonS3.generatePresignedUrl(request);
            return uRL;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public PresignedUrlDownloadResult download(PresignedUrlDownloadRequest request) {
        String function = "download";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            PresignedUrlDownloadResult presignedUrlDownloadResult = amazonS3.download(request);
            return presignedUrlDownloadResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public PresignedUrlUploadResult upload(PresignedUrlUploadRequest request) {
        String function = "upload";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            PresignedUrlUploadResult presignedUrlUploadResult = amazonS3.upload(request);
            return presignedUrlUploadResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

