/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.service;

import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.s3.logic.definition.service.BaseS3ClientService;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.DeleteVersionRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.RestoreObjectRequest;
import com.amazonaws.services.s3.model.RestoreObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazonaws.services.s3.model.SelectObjectContentResult;
import com.amazonaws.services.s3.model.WriteGetObjectResponseRequest;
import com.amazonaws.services.s3.model.WriteGetObjectResponseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3ObjectService
extends BaseS3ClientService {
    private static final Logger log = LoggerFactory.getLogger(S3ObjectService.class);

    public S3ObjectService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest request) {
        String function = "getObjectMetadata";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            ObjectMetadata objectMetadata = amazonS3.getObjectMetadata(request);
            return objectMetadata;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public S3Object getObject(GetObjectRequest request) {
        String function = "getObject";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            S3Object s3Object = amazonS3.getObject(request);
            return s3Object;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public PutObjectResult putObject(PutObjectRequest request) {
        String function = "putObject";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            PutObjectResult putObjectResult = amazonS3.putObject(request);
            return putObjectResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public CopyObjectResult copyObject(CopyObjectRequest request) {
        String function = "copyObject";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            CopyObjectResult copyObjectResult = amazonS3.copyObject(request);
            return copyObjectResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public void deleteObject(DeleteObjectRequest request) {
        String function = "deleteObject";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            amazonS3.deleteObject(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest request) {
        String function = "deleteObjects";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            DeleteObjectsResult deleteObjectsResult = amazonS3.deleteObjects(request);
            return deleteObjectsResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public void deleteObjects(DeleteVersionRequest request) {
        String function = "deleteObjects";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            amazonS3.deleteVersion(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public RestoreObjectResult restoreObject(RestoreObjectRequest request) {
        String function = "restoreObjectV2";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            RestoreObjectResult restoreObjectResult = amazonS3.restoreObjectV2(request);
            return restoreObjectResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public SelectObjectContentResult selectObjectContent(SelectObjectContentRequest request) {
        String function = "selectObjectContent";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            SelectObjectContentResult selectObjectContentResult = amazonS3.selectObjectContent(request);
            return selectObjectContentResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public WriteGetObjectResponseResult writeGetObjectResponse(WriteGetObjectResponseRequest request) {
        String function = "writeGetObjectResponse";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            WriteGetObjectResponseResult writeGetObjectResponseResult = amazonS3.writeGetObjectResponse(request);
            return writeGetObjectResponseResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public ObjectListing listObjects(ListObjectsRequest request) {
        String function = "listObjects";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            ObjectListing objectListing = amazonS3.listObjects(request);
            return objectListing;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public ListObjectsV2Result listObjectsV2(ListObjectsV2Request request) {
        String function = "listObjectsV2";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            ListObjectsV2Result listObjectsV2Result = amazonS3.listObjectsV2(request);
            return listObjectsV2Result;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public ObjectListing listNextBatchOfObjects(ListNextBatchOfObjectsRequest request) {
        String function = "listNextBatchOfObjects";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            ObjectListing objectListing = amazonS3.listNextBatchOfObjects(request);
            return objectListing;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

