/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.service;

import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.s3.logic.definition.service.BaseS3ClientService;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.GetObjectAclRequest;
import com.amazonaws.services.s3.model.SetObjectAclRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3ObjectAccessControlListService
extends BaseS3ClientService {
    private static final Logger log = LoggerFactory.getLogger(S3ObjectAccessControlListService.class);

    public S3ObjectAccessControlListService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public AccessControlList getObjectAccessControlList(GetObjectAclRequest request) {
        String function = "getObjectAccessControlList";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            AccessControlList accessControlList = amazonS3.getObjectAcl(request);
            return accessControlList;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public void setObjectAccessControlList(SetObjectAclRequest request) {
        String function = "setObjectAccessControlList";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            amazonS3.setObjectAcl(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

