/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.service;

import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.s3.logic.definition.service.BaseS3ClientService;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetS3AccountOwnerRequest;
import com.amazonaws.services.s3.model.Owner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3AccountOwnerService
extends BaseS3ClientService {
    private static final Logger log = LoggerFactory.getLogger(S3AccountOwnerService.class);

    public S3AccountOwnerService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public Owner getS3AccountOwner(GetS3AccountOwnerRequest request) {
        String function = "getS3AccountOwner";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            Owner owner = amazonS3.getS3AccountOwner(request);
            return owner;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

