/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.service;

import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.s3.logic.definition.service.BaseS3ClientService;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3MultipartUploadService
extends BaseS3ClientService {
    private static final Logger log = LoggerFactory.getLogger(S3MultipartUploadService.class);

    public S3MultipartUploadService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public CopyPartResult copyPart(CopyPartRequest request) {
        String function = "copyPart";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            CopyPartResult copyPartResult = amazonS3.copyPart(request);
            return copyPartResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) {
        String function = "initiateMultipartUpload";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            InitiateMultipartUploadResult initiateMultipartUploadResult = amazonS3.initiateMultipartUpload(request);
            return initiateMultipartUploadResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public UploadPartResult uploadPart(UploadPartRequest request) {
        String function = "uploadPart";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            UploadPartResult uploadPartResult = amazonS3.uploadPart(request);
            return uploadPartResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public PartListing listParts(ListPartsRequest request) {
        String function = "listParts";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            PartListing partListing = amazonS3.listParts(request);
            return partListing;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public void abortMultipartUpload(AbortMultipartUploadRequest request) {
        String function = "abortMultipartUpload";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            amazonS3.abortMultipartUpload(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest request) {
        String function = "completeMultipartUpload";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            CompleteMultipartUploadResult completeMultipartUploadResult = amazonS3.completeMultipartUpload(request);
            return completeMultipartUploadResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest request) {
        String function = "listMultipartUploads";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            MultipartUploadListing multipartUploadListing = amazonS3.listMultipartUploads(request);
            return multipartUploadListing;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

