/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.service;

import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.s3.logic.definition.service.BaseS3ClientService;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.BucketReplicationConfiguration;
import com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketReplicationConfigurationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3BucketReplicationConfigurationService
extends BaseS3ClientService {
    private static final Logger log = LoggerFactory.getLogger(S3BucketReplicationConfigurationService.class);

    public S3BucketReplicationConfigurationService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public void deleteBucketReplicationConfiguration(DeleteBucketReplicationConfigurationRequest request) {
        String function = "deleteBucketReplicationConfiguration";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            amazonS3.deleteBucketReplicationConfiguration(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public BucketReplicationConfiguration getBucketReplicationConfiguration(GetBucketReplicationConfigurationRequest request) {
        String function = "getBucketReplicationConfiguration";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            BucketReplicationConfiguration bucketReplicationConfiguration = amazonS3.getBucketReplicationConfiguration(request);
            return bucketReplicationConfiguration;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public void setBucketReplicationConfiguration(SetBucketReplicationConfigurationRequest request) {
        String function = "setBucketReplicationConfiguration";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            amazonS3.setBucketReplicationConfiguration(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

