/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.service;

import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.s3.logic.definition.service.BaseS3ClientService;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketIntelligentTieringConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketIntelligentTieringConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketIntelligentTieringConfigurationResult;
import com.amazonaws.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketIntelligentTieringConfigurationsResult;
import com.amazonaws.services.s3.model.SetBucketIntelligentTieringConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketIntelligentTieringConfigurationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3BucketIntelligentTieringConfigurationService
extends BaseS3ClientService {
    private static final Logger log = LoggerFactory.getLogger(S3BucketIntelligentTieringConfigurationService.class);

    public S3BucketIntelligentTieringConfigurationService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public DeleteBucketIntelligentTieringConfigurationResult deleteBucketIntelligentTieringConfiguration(DeleteBucketIntelligentTieringConfigurationRequest request) {
        String function = "deleteBucketIntelligentTieringConfiguration";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            DeleteBucketIntelligentTieringConfigurationResult deleteBucketIntelligentTieringConfigurationResult = amazonS3.deleteBucketIntelligentTieringConfiguration(request);
            return deleteBucketIntelligentTieringConfigurationResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public GetBucketIntelligentTieringConfigurationResult getBucketIntelligentTieringConfiguration(GetBucketIntelligentTieringConfigurationRequest request) {
        String function = "getBucketIntelligentTieringConfiguration";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            GetBucketIntelligentTieringConfigurationResult getBucketIntelligentTieringConfigurationResult = amazonS3.getBucketIntelligentTieringConfiguration(request);
            return getBucketIntelligentTieringConfigurationResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public ListBucketIntelligentTieringConfigurationsResult listBucketIntelligentTieringConfigurations(ListBucketIntelligentTieringConfigurationsRequest request) {
        String function = "listBucketIntelligentTieringConfigurations";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            ListBucketIntelligentTieringConfigurationsResult listBucketIntelligentTieringConfigurationsResult = amazonS3.listBucketIntelligentTieringConfigurations(request);
            return listBucketIntelligentTieringConfigurationsResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public SetBucketIntelligentTieringConfigurationResult setBucketIntelligentTieringConfiguration(SetBucketIntelligentTieringConfigurationRequest request) {
        String function = "setBucketIntelligentTieringConfiguration";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            SetBucketIntelligentTieringConfigurationResult setBucketIntelligentTieringConfigurationResult = amazonS3.setBucketIntelligentTieringConfiguration(request);
            return setBucketIntelligentTieringConfigurationResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

