/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.service;

import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.s3.logic.definition.service.BaseS3ClientService;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteBucketEncryptionRequest;
import com.amazonaws.services.s3.model.DeleteBucketEncryptionResult;
import com.amazonaws.services.s3.model.GetBucketEncryptionRequest;
import com.amazonaws.services.s3.model.GetBucketEncryptionResult;
import com.amazonaws.services.s3.model.SetBucketEncryptionRequest;
import com.amazonaws.services.s3.model.SetBucketEncryptionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3BucketEncryptionService
extends BaseS3ClientService {
    private static final Logger log = LoggerFactory.getLogger(S3BucketEncryptionService.class);

    public S3BucketEncryptionService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public DeleteBucketEncryptionResult deleteBucketEncryption(DeleteBucketEncryptionRequest request) {
        String function = "deleteBucketEncryption";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            DeleteBucketEncryptionResult deleteBucketEncryptionResult = amazonS3.deleteBucketEncryption(request);
            return deleteBucketEncryptionResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public GetBucketEncryptionResult getBucketEncryption(GetBucketEncryptionRequest request) {
        String function = "getBucketEncryption";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            GetBucketEncryptionResult getBucketEncryptionResult = amazonS3.getBucketEncryption(request);
            return getBucketEncryptionResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public SetBucketEncryptionResult setBucketEncryption(SetBucketEncryptionRequest request) {
        String function = "setBucketEncryption";
        AmazonS3 amazonS3 = this.getAmazonS3();
        try {
            SetBucketEncryptionResult setBucketEncryptionResult = amazonS3.setBucketEncryption(request);
            return setBucketEncryptionResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

