/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.s3.logic.definition.pool;

import cn.herodotus.oss.definition.core.exception.OssClientPoolErrorException;
import cn.herodotus.oss.s3.logic.definition.pool.S3ClientPooledObjectFactory;
import cn.herodotus.oss.s3.logic.properties.S3Properties;
import com.amazonaws.services.s3.AmazonS3;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class S3ClientObjectPool {
    private static final Logger log = LoggerFactory.getLogger(S3ClientObjectPool.class);
    private final GenericObjectPool<AmazonS3> genericObjectPool;

    public S3ClientObjectPool(S3Properties minioProperties) {
        S3ClientPooledObjectFactory factory = new S3ClientPooledObjectFactory(minioProperties);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(minioProperties.getPool().getMaxTotal().intValue());
        config.setMaxIdle(minioProperties.getPool().getMaxIdle().intValue());
        config.setMinIdle(minioProperties.getPool().getMinIdle().intValue());
        config.setMaxWait(minioProperties.getPool().getMaxWait());
        config.setMinEvictableIdleTime(minioProperties.getPool().getMinEvictableIdleTime());
        config.setSoftMinEvictableIdleTime(minioProperties.getPool().getSoftMinEvictableIdleTime());
        config.setLifo(minioProperties.getPool().getLifo().booleanValue());
        config.setBlockWhenExhausted(minioProperties.getPool().getBlockWhenExhausted().booleanValue());
        this.genericObjectPool = new GenericObjectPool((PooledObjectFactory)factory, config);
    }

    public AmazonS3 getAmazonS3() {
        try {
            AmazonS3 minioClient = (AmazonS3)this.genericObjectPool.borrowObject();
            log.debug("[Herodotus] |- Fetch amazon s3 client from object pool.");
            return minioClient;
        }
        catch (Exception e) {
            log.error("[Herodotus] |- Can not fetch amazon s3 client from pool.", (Throwable)e);
            throw new OssClientPoolErrorException("Can not fetch amazon s3 client from pool.");
        }
    }

    public void close(AmazonS3 minioClient) {
        if (ObjectUtils.isNotEmpty((Object)minioClient)) {
            log.debug("[Herodotus] |- Close minio client.");
            this.genericObjectPool.returnObject((Object)minioClient);
        }
    }
}

