/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.rest.scenario.service;

import cn.herodotus.oss.dialect.core.exception.OssIOException;
import cn.herodotus.oss.dialect.minio.converter.ResponseToObjectWriteDomainConverter;
import cn.herodotus.oss.dialect.minio.domain.ObjectWriteDomain;
import cn.herodotus.oss.dialect.minio.service.MinioObjectService;
import io.minio.GetObjectResponse;
import io.minio.ObjectWriteResponse;
import io.minio.StatObjectResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MinioObjectStreamService {
    private static final Logger log = LoggerFactory.getLogger(MinioObjectStreamService.class);
    private final MinioObjectService minioObjectService;
    private final Converter<ObjectWriteResponse, ObjectWriteDomain> toObjectWriteDomain;

    public MinioObjectStreamService(MinioObjectService minioObjectService) {
        this.minioObjectService = minioObjectService;
        this.toObjectWriteDomain = new ResponseToObjectWriteDomainConverter();
    }

    public void download(String bucketName, String objectName, HttpServletResponse response) throws IOException {
        StatObjectResponse statObject = this.minioObjectService.statObject(bucketName, objectName);
        response.setContentType(statObject.contentType());
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(objectName, StandardCharsets.UTF_8));
        GetObjectResponse is = this.minioObjectService.getObject(bucketName, objectName);
        IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
        IOUtils.closeQuietly((InputStream)is);
    }

    public ObjectWriteDomain upload(String bucketName, MultipartFile file) {
        try {
            ObjectWriteResponse response = this.minioObjectService.putObject(bucketName, file.getOriginalFilename(), file.getInputStream(), file.getSize(), file.getContentType());
            return (ObjectWriteDomain)this.toObjectWriteDomain.convert((Object)response);
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio upload catch IOException.", (Throwable)e);
            throw new OssIOException(e.getMessage());
        }
    }
}

