/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.rest.scenario.service;

import cn.herodotus.oss.dialect.minio.converter.ResponseToObjectWriteDomainConverter;
import cn.herodotus.oss.dialect.minio.domain.ObjectWriteDomain;
import cn.herodotus.oss.dialect.minio.service.MinioMultipartUploadService;
import cn.herodotus.oss.dialect.minio.service.MinioPresignedObjectUrlService;
import cn.herodotus.oss.rest.scenario.bo.ChunkUploadCreateBusiness;
import cn.herodotus.oss.rest.scenario.proxy.MinioProxyAddressConverter;
import io.minio.CreateMultipartUploadResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListPartsResponse;
import io.minio.ObjectWriteResponse;
import io.minio.http.Method;
import io.minio.messages.Part;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Component;

@Component
public class MinioChunkUploadService {
    private final MinioMultipartUploadService minioMultipartUploadService;
    private final MinioPresignedObjectUrlService minioPresignedObjectUrlService;
    private final MinioProxyAddressConverter converter;

    public MinioChunkUploadService(MinioMultipartUploadService minioMultipartUploadService, MinioPresignedObjectUrlService minioPresignedObjectUrlService, MinioProxyAddressConverter converter) {
        this.minioMultipartUploadService = minioMultipartUploadService;
        this.minioPresignedObjectUrlService = minioPresignedObjectUrlService;
        this.converter = converter;
    }

    private String createUploadId(String bucketName, String region, String objectName) {
        CreateMultipartUploadResponse response = this.minioMultipartUploadService.createMultipartUpload(bucketName, region, objectName, null, null);
        return response.result().uploadId();
    }

    private String createPresignedObjectUrl(String bucketName, String region, String objectName, String uploadId, int partNumber) {
        HashMap<String, String> extraQueryParams = new HashMap<String, String>();
        extraQueryParams.put("partNumber", String.valueOf(partNumber));
        extraQueryParams.put("uploadId", uploadId);
        GetPresignedObjectUrlArgs args = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucketName)).region(region)).object(objectName)).method(Method.PUT).extraQueryParams(extraQueryParams)).expiry(1, TimeUnit.HOURS).build();
        return this.minioPresignedObjectUrlService.getPresignedObjectUrl(args);
    }

    private Part[] listParts(String bucketName, String region, String objectName, String uploadId) {
        ListPartsResponse response = this.minioMultipartUploadService.listParts(bucketName, region, objectName, uploadId);
        List partList = response.result().partList();
        Part[] parts = new Part[partList.size()];
        return partList.toArray(parts);
    }

    private ChunkUploadCreateBusiness createMultipartUpload(String bucketName, String region, String objectName, int totalParts) {
        String uploadId = this.createUploadId(bucketName, region, objectName);
        ChunkUploadCreateBusiness entity = new ChunkUploadCreateBusiness(uploadId);
        for (int i = 1; i <= totalParts; ++i) {
            String uploadUrl = this.createPresignedObjectUrl(bucketName, region, objectName, uploadId, i);
            entity.appendChunk(this.converter.toServiceUrl(uploadUrl));
        }
        return entity;
    }

    public ChunkUploadCreateBusiness createMultipartUpload(String bucketName, String objectName, int totalParts) {
        return this.createMultipartUpload(bucketName, null, objectName, totalParts);
    }

    private ObjectWriteDomain completeMultipartUpload(String bucketName, String region, String objectName, String uploadId) {
        Object[] parts = this.listParts(bucketName, region, objectName, uploadId);
        if (ArrayUtils.isNotEmpty((Object[])parts)) {
            ObjectWriteResponse response = this.minioMultipartUploadService.completeMultipartUpload(bucketName, region, objectName, uploadId, (Part[])parts);
            ResponseToObjectWriteDomainConverter toDomain = new ResponseToObjectWriteDomainConverter();
            if (ObjectUtils.isNotEmpty((Object)response)) {
                return (ObjectWriteDomain)toDomain.convert((Object)response);
            }
        }
        return null;
    }

    public ObjectWriteDomain completeMultipartUpload(String bucketName, String objectName, String uploadId) {
        return this.completeMultipartUpload(bucketName, null, objectName, uploadId);
    }
}

