/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.rest.scenario.controller;

import cn.herodotus.engine.rest.core.annotation.Idempotent;
import cn.herodotus.oss.dialect.minio.domain.ObjectWriteDomain;
import cn.herodotus.oss.rest.scenario.request.ObjectDownloadRequest;
import cn.herodotus.oss.rest.scenario.service.MinioObjectStreamService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/oss/minio/object/stream"})
@Tags(value={@Tag(name="\u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u4e0b\u8f7d\u63a5\u53e3")})
public class MinioObjectStreamController {
    private static final Logger log = LoggerFactory.getLogger(MinioObjectStreamController.class);
    private final MinioObjectStreamService minioObjectStreamService;

    public MinioObjectStreamController(MinioObjectStreamService minioObjectStreamService) {
        this.minioObjectStreamService = minioObjectStreamService;
    }

    @Idempotent
    @Operation(summary="\u4e0b\u8f7d", description="\u4e0b\u8f7dObject\u5bf9\u5e94\u7684\u6587\u4ef6", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u6240\u6709\u5bf9\u8c61", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="200", description="\u64cd\u4f5c\u6210\u529f"), @ApiResponse(responseCode="500", description="\u64cd\u4f5c\u5931\u8d25"), @ApiResponse(responseCode="503", description="Minio Server\u65e0\u6cd5\u8bbf\u95ee\u6216\u672a\u542f\u52a8")})
    @Parameters(value={@Parameter(name="request", required=true, description="ObjectDownloadRequest\u8bf7\u6c42\u53c2\u6570\u5b9e\u4f53", schema=@Schema(implementation=ObjectDownloadRequest.class))})
    @PostMapping(value={"/download"})
    public void download(@Validated @RequestBody ObjectDownloadRequest request, HttpServletResponse response) {
        try {
            this.minioObjectStreamService.download(request.getBucketName(), request.getObjectName(), response);
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Download file from minio catch error", (Throwable)e);
        }
    }

    @Idempotent
    @Operation(summary="\u6587\u4ef6\u4e0a\u4f20", description="\u666e\u901a\u7684\u6587\u4ef6\u4e0a\u4f20\u64cd\u4f5c\u63a5\u53e3", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u6240\u6709\u5bf9\u8c61", content={@Content(mediaType="application/json", schema=@Schema(implementation=ObjectWriteDomain.class))}), @ApiResponse(responseCode="200", description="\u64cd\u4f5c\u6210\u529f"), @ApiResponse(responseCode="500", description="\u64cd\u4f5c\u5931\u8d25"), @ApiResponse(responseCode="503", description="Minio Server\u65e0\u6cd5\u8bbf\u95ee\u6216\u672a\u542f\u52a8")})
    @Parameters(value={@Parameter(name="bucketName", required=true, description="\u5b58\u50a8\u6876\u540d\u79f0"), @Parameter(name="file", required=true, description="\u6587\u4ef6", schema=@Schema(implementation=MultipartFile.class))})
    @PostMapping(value={"/upload"})
    public ObjectWriteDomain upload(@RequestParam(value="bucketName") String bucketName, @RequestPart(value="file") MultipartFile file, HttpServletRequest request) {
        return this.minioObjectStreamService.upload(bucketName, file);
    }
}

