/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.rest.scenario.controller;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.rest.core.annotation.Idempotent;
import cn.herodotus.engine.rest.core.controller.Controller;
import cn.herodotus.oss.dialect.minio.domain.ObjectWriteDomain;
import cn.herodotus.oss.rest.scenario.bo.ChunkUploadCreateBusiness;
import cn.herodotus.oss.rest.scenario.proxy.MinioPresignedObjectUrlProxy;
import cn.herodotus.oss.rest.scenario.request.ChunkUploadCompleteRequest;
import cn.herodotus.oss.rest.scenario.request.ChunkUploadCreateRequest;
import cn.herodotus.oss.rest.scenario.service.MinioChunkUploadService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oss/minio/chunk"})
@Tags(value={@Tag(name="\u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="\u5927\u6587\u4ef6\u5206\u7247\u76f4\u4f20\u63a5\u53e3")})
public class MinioChunkUploadController
implements Controller {
    private final MinioChunkUploadService minioChunkUploadService;
    private final MinioPresignedObjectUrlProxy presignedObjectUrlDelegate;

    public MinioChunkUploadController(MinioChunkUploadService minioChunkUploadService, MinioPresignedObjectUrlProxy presignedObjectUrlDelegate) {
        this.minioChunkUploadService = minioChunkUploadService;
        this.presignedObjectUrlDelegate = presignedObjectUrlDelegate;
    }

    @Idempotent
    @Operation(summary="\u521b\u5efa\u5206\u7247\u4e0a\u4f20\u4fe1\u606f", description="\u521b\u5efa\u5206\u7247\u4e0a\u4f20\u4fe1\u606f", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="uploadId \u548c \u9884\u4e0b\u8f7d\u5730\u5740", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChunkUploadCreateBusiness.class))}), @ApiResponse(responseCode="200", description="\u64cd\u4f5c\u6210\u529f"), @ApiResponse(responseCode="204", description="\u65e0\u7ed3\u679c"), @ApiResponse(responseCode="500", description="\u64cd\u4f5c\u5931\u8d25")})
    @Parameters(value={@Parameter(name="request", required=true, description="MultipartUploadCreateRequest\u53c2\u6570\u5b9e\u4f53", schema=@Schema(implementation=ChunkUploadCreateRequest.class))})
    @PostMapping(value={"/create"})
    public Result<ChunkUploadCreateBusiness> createMultipartUpload(@Validated @RequestBody ChunkUploadCreateRequest request) {
        ChunkUploadCreateBusiness result = this.minioChunkUploadService.createMultipartUpload(request.getBucketName(), request.getObjectName(), request.getSize());
        return this.result(result);
    }

    @Idempotent
    @Operation(summary="\u5b8c\u6210\u5206\u7247\u4e0a\u4f20", description="\u5b8c\u6210\u5206\u7247\u4e0a\u4f20\uff0cMinio\u5c06\u4e0a\u4f20\u5b8c\u6210\u7684\u5206\u7247\u4fe1\u606f\u8fdb\u884c\u5408\u5e76", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u64cd\u4f5c\u7ed3\u679c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ObjectWriteDomain.class))}), @ApiResponse(responseCode="200", description="\u64cd\u4f5c\u6210\u529f"), @ApiResponse(responseCode="204", description="\u65e0\u7ed3\u679c"), @ApiResponse(responseCode="500", description="\u64cd\u4f5c\u5931\u8d25")})
    @Parameters(value={@Parameter(name="request", required=true, description="MultipartUploadCompleteRequest\u53c2\u6570\u5b9e\u4f53", schema=@Schema(implementation=ChunkUploadCompleteRequest.class))})
    @PostMapping(value={"/complete"})
    public Result<ObjectWriteDomain> completeMultipartUpload(@Validated @RequestBody ChunkUploadCompleteRequest request) {
        ObjectWriteDomain entity = this.minioChunkUploadService.completeMultipartUpload(request.getBucketName(), request.getObjectName(), request.getUploadId());
        return this.result((Entity)entity);
    }

    @Operation(summary="\u9884\u4e0b\u8f7d\u4ee3\u7406\u5730\u5740", description="\u9884\u4e0b\u8f7d\u4ee3\u7406\u5730\u5740\uff0c\u907f\u514d\u524d\u7aef\u76f4\u63a5\u8bbf\u95eeOSS\uff0c\u540c\u65f6\u5bfc\u81f4\u5fae\u670d\u52a1\u5bfb\u5740\u9519\u8bef", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u64cd\u4f5c\u7ed3\u679c", content={@Content(mediaType="application/json")})})
    @PutMapping(value={"/presigned/*/*"})
    public ResponseEntity<String> presignedObjectProxy(HttpServletRequest request) {
        return this.presignedObjectUrlDelegate.delegate(request);
    }
}

