/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.rest.minio.definition;

import cn.herodotus.oss.rest.minio.definition.BaseRequest;
import io.minio.BucketArgs;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

public abstract class BucketRequest<B extends BucketArgs.Builder<B, A>, A extends BucketArgs>
extends BaseRequest<B, A> {
    @Schema(name="\u5b58\u50a8\u6876\u540d\u79f0", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotBlank(message="\u5b58\u50a8\u6876\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=3, max=62, message="\u5b58\u50a8\u6876\u540d\u79f0\u4e0d\u80fd\u5c11\u4e8e3\u4e2a\u5b57\u7b26\uff0c\u4e0d\u80fd\u5927\u4e8e63\u4e2a\u5b57\u7b26")
    @Pattern(regexp="^[a-z0-9][a-z0-9\\.\\-]+[a-z0-9]$", message="\u5b58\u50a8\u6876\u540d\u79f0\u65e0\u6cd5\u4e0eDNS\u517c\u5bb9")
    private @NotBlank(message="\u5b58\u50a8\u6876\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @Length(min=3, max=62, message="\u5b58\u50a8\u6876\u540d\u79f0\u4e0d\u80fd\u5c11\u4e8e3\u4e2a\u5b57\u7b26\uff0c\u4e0d\u80fd\u5927\u4e8e63\u4e2a\u5b57\u7b26") @Pattern(regexp="^[a-z0-9][a-z0-9\\.\\-]+[a-z0-9]$", message="\u5b58\u50a8\u6876\u540d\u79f0\u65e0\u6cd5\u4e0eDNS\u517c\u5bb9") String bucketName;
    @Schema(name="\u5b58\u50a8\u533a\u57df")
    private String region;

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @Override
    public void prepare(B builder) {
        builder.bucket(this.getBucketName());
        if (StringUtils.isNotBlank((CharSequence)this.getRegion())) {
            builder.region(this.getRegion());
        }
        super.prepare(builder);
    }
}

