/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.rest.minio.controller;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.rest.core.annotation.AccessLimited;
import cn.herodotus.engine.rest.core.annotation.Idempotent;
import cn.herodotus.engine.rest.core.controller.Controller;
import cn.herodotus.oss.dialect.minio.converter.UserInfoToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.UsersToDomainsConverter;
import cn.herodotus.oss.dialect.minio.domain.UserDomain;
import cn.herodotus.oss.dialect.minio.service.MinioAdminUserService;
import io.minio.admin.UserInfo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oss/minio/admin/user"})
@Tags(value={@Tag(name="\u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u7528\u6237\u7ba1\u7406\u63a5\u53e3")})
public class MinioAdminUserController
implements Controller {
    private final MinioAdminUserService minioAdminUserService;
    private final Converter<Map<String, UserInfo>, List<UserDomain>> toDomains;
    private final Converter<UserInfo, UserDomain> toDomain;

    public MinioAdminUserController(MinioAdminUserService minioAdminUserService) {
        this.minioAdminUserService = minioAdminUserService;
        this.toDomains = new UsersToDomainsConverter();
        this.toDomain = new UserInfoToDomainConverter();
    }

    @AccessLimited
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u7528\u6237\u4fe1\u606f", description="\u83b7\u53d6\u5168\u90e8\u7528\u6237\u4fe1\u606f", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u6240\u6709Buckets", content={@Content(mediaType="application/json", schema=@Schema(implementation=List.class))}), @ApiResponse(responseCode="200", description="\u67e5\u8be2\u6210\u529f\uff0c\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="204", description="\u67e5\u8be2\u6210\u529f\uff0c\u672a\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="500", description="\u67e5\u8be2\u5931\u8d25"), @ApiResponse(responseCode="503", description="Minio Server\u65e0\u6cd5\u8bbf\u95ee\u6216\u672a\u542f\u52a8")})
    @GetMapping(value={"/list"})
    public Result<List<UserDomain>> list() {
        Map users = this.minioAdminUserService.listUsers();
        List domains = (List)this.toDomains.convert((Object)users);
        return this.result(domains);
    }

    @AccessLimited
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", description="\u6839\u636e\u7528\u6237 AccessKey \u83b7\u53d6 Minio \u7528\u6237\u4fe1\u606f", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u7528\u6237\u4fe1\u606f", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserDomain.class))}), @ApiResponse(responseCode="200", description="\u67e5\u8be2\u6210\u529f"), @ApiResponse(responseCode="500", description="\u67e5\u8be2\u5931\u8d25"), @ApiResponse(responseCode="503", description="Minio Server\u65e0\u6cd5\u8bbf\u95ee\u6216\u672a\u542f\u52a8")})
    @Parameters(value={@Parameter(name="accessKey", required=true, description="\u7528\u6237\u5bf9\u5e94 AccessKey \u6807\u8bc6")})
    @GetMapping
    public Result<UserDomain> get(String accessKey) {
        UserInfo userInfo = this.minioAdminUserService.getUserInfo(accessKey);
        UserDomain userDomain = (UserDomain)this.toDomain.convert((Object)userInfo);
        return this.result((Entity)userDomain);
    }

    @Idempotent
    @Operation(summary="\u521b\u5efa\u7528\u6237", description="\u521b\u5efa Minio \u7528\u6237", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="Minio API \u65e0\u8fd4\u56de\u503c\uff0c\u6240\u4ee5\u8fd4\u56de200\u5373\u8868\u793a\u6210\u529f\uff0c\u4e0d\u6210\u529f\u4f1a\u629b\u9519", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="200", description="\u64cd\u4f5c\u6210\u529f"), @ApiResponse(responseCode="500", description="\u64cd\u4f5c\u5931\u8d25\uff0c\u5177\u4f53\u67e5\u770b\u9519\u8bef\u4fe1\u606f\u5185\u5bb9"), @ApiResponse(responseCode="503", description="Minio Server\u65e0\u6cd5\u8bbf\u95ee\u6216\u672a\u542f\u52a8")})
    @Parameters(value={@Parameter(name="domain", required=true, description="UserDomain\u5b9e\u4f53", schema=@Schema(implementation=UserDomain.class))})
    @PostMapping
    public Result<Boolean> add(@Validated @RequestBody UserDomain domain) {
        this.minioAdminUserService.addUser(domain.getAccessKey(), UserInfo.Status.fromString((String)domain.getStatus().name()), domain.getSecretKey(), domain.getPolicyName(), domain.getMemberOf());
        return this.result(true);
    }

    @Idempotent
    @Operation(summary="\u5220\u9664\u7528\u6237", description="\u6839\u636e\u7528\u6237 AccessKey \u5220\u9664\u7528\u6237\u4fe1\u606f", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="Minio API \u65e0\u8fd4\u56de\u503c\uff0c\u6240\u4ee5\u8fd4\u56de200\u5373\u8868\u793a\u6210\u529f\uff0c\u4e0d\u6210\u529f\u4f1a\u629b\u9519", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="200", description="\u64cd\u4f5c\u6210\u529f"), @ApiResponse(responseCode="500", description="\u64cd\u4f5c\u5931\u8d25\uff0c\u5177\u4f53\u67e5\u770b\u9519\u8bef\u4fe1\u606f\u5185\u5bb9"), @ApiResponse(responseCode="503", description="Minio Server \u65e0\u6cd5\u8bbf\u95ee\u6216\u672a\u542f\u52a8")})
    @Parameters(value={@Parameter(name="accessKey", required=true, description="\u7528\u6237\u5bf9\u5e94 AccessKey \u6807\u8bc6")})
    @DeleteMapping
    public Result<Boolean> remove(String accessKey) {
        this.minioAdminUserService.deleteUser(accessKey);
        return this.result(true);
    }
}

