/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.rest.minio.request.object;

import cn.herodotus.oss.rest.minio.converter.RequestToCopySourceConverter;
import cn.herodotus.oss.rest.minio.definition.ObjectWriteRequest;
import cn.herodotus.oss.rest.minio.request.domain.CopySourceRequest;
import cn.herodotus.oss.rest.minio.request.object.ComposeObjectRequest;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.Directive;
import jakarta.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;

public class CopyObjectRequest
extends ObjectWriteRequest<CopyObjectArgs.Builder, CopyObjectArgs> {
    private final Converter<CopySourceRequest, CopySource> requestTo = new RequestToCopySourceConverter();
    @NotNull(message="source \u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="source \u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a") CopySourceRequest source;
    private String metadataDirective;
    private String taggingDirective;

    public CopyObjectRequest(ComposeObjectRequest request) {
        this.setExtraHeaders(request.getExtraHeaders());
        this.setExtraQueryParams(request.getExtraQueryParams());
        this.setBucketName(request.getBucketName());
        this.setRegion(request.getRegion());
        this.setObjectName(request.getObjectName());
        this.setHeaders(request.getHeaders());
        this.setUserMetadata(request.getUserMetadata());
        this.setServerSideEncryption(request.getServerSideEncryption());
        this.setTags(request.getTags());
        this.setRetention(request.getRetention());
        this.setLegalHold(request.getLegalHold());
        this.source = new CopySourceRequest(request.getSources().get(0));
    }

    public CopySourceRequest getSource() {
        return this.source;
    }

    public void setSource(CopySourceRequest source) {
        this.source = source;
    }

    public String getMetadataDirective() {
        return this.metadataDirective;
    }

    public void setMetadataDirective(String metadataDirective) {
        this.metadataDirective = metadataDirective;
    }

    public String getTaggingDirective() {
        return this.taggingDirective;
    }

    public void setTaggingDirective(String taggingDirective) {
        this.taggingDirective = taggingDirective;
    }

    @Override
    public void prepare(CopyObjectArgs.Builder builder) {
        builder.source((CopySource)this.requestTo.convert((Object)this.getSource()));
        if (StringUtils.isNotBlank((CharSequence)this.getMetadataDirective())) {
            builder.metadataDirective(Directive.valueOf((String)this.getMetadataDirective()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTaggingDirective())) {
            builder.taggingDirective(Directive.valueOf((String)this.getTaggingDirective()));
        }
        super.prepare(builder);
    }

    @Override
    public CopyObjectArgs.Builder getBuilder() {
        return CopyObjectArgs.builder();
    }
}

