/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.specification.core.repository;

import cn.herodotus.oss.specification.arguments.object.DeleteObjectArguments;
import cn.herodotus.oss.specification.arguments.object.DeleteObjectsArguments;
import cn.herodotus.oss.specification.arguments.object.DownloadObjectArguments;
import cn.herodotus.oss.specification.arguments.object.GeneratePresignedUrlArguments;
import cn.herodotus.oss.specification.arguments.object.GetObjectArguments;
import cn.herodotus.oss.specification.arguments.object.GetObjectMetadataArguments;
import cn.herodotus.oss.specification.arguments.object.ListObjectsArguments;
import cn.herodotus.oss.specification.arguments.object.ListObjectsV2Arguments;
import cn.herodotus.oss.specification.arguments.object.PutObjectArguments;
import cn.herodotus.oss.specification.arguments.object.UploadObjectArguments;
import cn.herodotus.oss.specification.domain.base.ObjectWriteDomain;
import cn.herodotus.oss.specification.domain.object.DeleteObjectDomain;
import cn.herodotus.oss.specification.domain.object.GetObjectDomain;
import cn.herodotus.oss.specification.domain.object.ListObjectsDomain;
import cn.herodotus.oss.specification.domain.object.ListObjectsV2Domain;
import cn.herodotus.oss.specification.domain.object.ObjectMetadataDomain;
import cn.herodotus.oss.specification.domain.object.PutObjectDomain;
import cn.herodotus.oss.specification.enums.HttpMethod;
import java.time.Duration;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public interface OssObjectRepository {
    default public ListObjectsDomain listObjects(String bucketName) {
        return this.listObjects(bucketName, null);
    }

    default public ListObjectsDomain listObjects(String bucketName, String prefix) {
        ListObjectsArguments arguments = new ListObjectsArguments();
        arguments.setBucketName(bucketName);
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            arguments.setPrefix(prefix);
        }
        return this.listObjects(arguments);
    }

    public ListObjectsDomain listObjects(ListObjectsArguments var1);

    default public ListObjectsV2Domain listObjectsV2(String bucketName) {
        return this.listObjectsV2(bucketName, null);
    }

    default public ListObjectsV2Domain listObjectsV2(String bucketName, String prefix) {
        ListObjectsV2Arguments arguments = new ListObjectsV2Arguments();
        arguments.setBucketName(bucketName);
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            arguments.setPrefix(prefix);
        }
        return this.listObjectsV2(arguments);
    }

    public ListObjectsV2Domain listObjectsV2(ListObjectsV2Arguments var1);

    default public void deleteObject(String bucketName, String objectName) {
        DeleteObjectArguments arguments = new DeleteObjectArguments();
        arguments.setBucketName(bucketName);
        arguments.setObjectName(objectName);
        this.deleteObject(arguments);
    }

    public void deleteObject(DeleteObjectArguments var1);

    public List<DeleteObjectDomain> deleteObjects(DeleteObjectsArguments var1);

    default public ObjectMetadataDomain getObjectMetadata(String bucketName, String objectName) {
        GetObjectMetadataArguments arguments = new GetObjectMetadataArguments();
        arguments.setBucketName(bucketName);
        arguments.setObjectName(objectName);
        return this.getObjectMetadata(arguments);
    }

    public ObjectMetadataDomain getObjectMetadata(GetObjectMetadataArguments var1);

    default public GetObjectDomain getObject(String bucketName, String objectName) {
        GetObjectArguments arguments = new GetObjectArguments();
        arguments.setBucketName(bucketName);
        arguments.setObjectName(objectName);
        return this.getObject(arguments);
    }

    public GetObjectDomain getObject(GetObjectArguments var1);

    public PutObjectDomain putObject(PutObjectArguments var1);

    default public String generatePresignedUrl(String bucketName, String objectName, Duration expiration) {
        return this.generatePresignedUrl(bucketName, objectName, expiration, HttpMethod.GET);
    }

    default public String generatePresignedUrl(String bucketName, String objectName, Duration expiration, HttpMethod method) {
        GeneratePresignedUrlArguments arguments = new GeneratePresignedUrlArguments();
        arguments.setBucketName(bucketName);
        arguments.setObjectName(objectName);
        arguments.setExpiration(expiration);
        arguments.setMethod(method);
        return this.generatePresignedUrl(arguments);
    }

    public String generatePresignedUrl(GeneratePresignedUrlArguments var1);

    public ObjectMetadataDomain download(DownloadObjectArguments var1);

    public ObjectWriteDomain upload(UploadObjectArguments var1);
}

