/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.solution.service;

import cn.herodotus.oss.dialect.core.exception.OssIOException;
import cn.herodotus.oss.specification.arguments.object.PutObjectArguments;
import cn.herodotus.oss.specification.core.repository.OssObjectRepository;
import cn.herodotus.oss.specification.domain.object.GetObjectDomain;
import cn.herodotus.oss.specification.domain.object.ObjectMetadataDomain;
import cn.herodotus.oss.specification.domain.object.PutObjectDomain;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OssObjectStreamService {
    private static final Logger log = LoggerFactory.getLogger(OssObjectStreamService.class);
    private final OssObjectRepository ossObjectRepository;

    public OssObjectStreamService(OssObjectRepository ossObjectRepository) {
        this.ossObjectRepository = ossObjectRepository;
    }

    private void stream(String bucketName, String objectName, boolean isOnline, HttpServletResponse response) throws IOException {
        ObjectMetadataDomain objectMetadata = this.ossObjectRepository.getObjectMetadata(bucketName, objectName);
        String type = isOnline ? "inline" : "attachment";
        response.setContentType(objectMetadata.getContentType());
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setHeader("Content-Disposition", type + ";filename=" + URLEncoder.encode(objectName, StandardCharsets.UTF_8));
        GetObjectDomain domain = this.ossObjectRepository.getObject(bucketName, objectName);
        InputStream is = domain.getObjectContent();
        IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
        IOUtils.closeQuietly((InputStream)is);
    }

    public void download(String bucketName, String objectName, HttpServletResponse response) throws IOException {
        this.stream(bucketName, objectName, false, response);
    }

    public void display(String bucketName, String objectName, HttpServletResponse response) throws IOException {
        this.stream(bucketName, objectName, true, response);
    }

    public PutObjectDomain upload(String bucketName, MultipartFile file) {
        try {
            PutObjectArguments arguments = new PutObjectArguments();
            arguments.setContentType(file.getContentType());
            arguments.setObjectSize(Long.valueOf(file.getSize()));
            arguments.setPartSize(Long.valueOf(-1L));
            arguments.setInputStream(file.getInputStream());
            arguments.setObjectName(file.getOriginalFilename());
            arguments.setBucketName(bucketName);
            return this.ossObjectRepository.putObject(arguments);
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio upload catch IOException.", (Throwable)e);
            throw new OssIOException(e.getMessage());
        }
    }
}

