/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.solution.service;

import cn.herodotus.oss.solution.business.CreateMultipartUploadBusiness;
import cn.herodotus.oss.solution.proxy.OssProxyAddressConverter;
import cn.herodotus.oss.specification.arguments.object.GeneratePresignedUrlArguments;
import cn.herodotus.oss.specification.core.repository.OssMultipartUploadRepository;
import cn.herodotus.oss.specification.core.repository.OssObjectRepository;
import cn.herodotus.oss.specification.domain.multipart.CompleteMultipartUploadDomain;
import cn.herodotus.oss.specification.domain.multipart.ListPartsDomain;
import cn.herodotus.oss.specification.domain.multipart.PartSummaryDomain;
import cn.herodotus.oss.specification.enums.HttpMethod;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class OssMultipartUploadService {
    private final OssObjectRepository ossObjectRepository;
    private final OssMultipartUploadRepository ossMultipartUploadRepository;
    private final OssProxyAddressConverter ossProxyAddressConverter;

    public OssMultipartUploadService(OssObjectRepository ossObjectRepository, OssMultipartUploadRepository ossMultipartUploadRepository, OssProxyAddressConverter ossProxyAddressConverter) {
        this.ossObjectRepository = ossObjectRepository;
        this.ossMultipartUploadRepository = ossMultipartUploadRepository;
        this.ossProxyAddressConverter = ossProxyAddressConverter;
    }

    private String createUploadId(String bucketName, String objectName) {
        return this.ossMultipartUploadRepository.initiateMultipartUpload(bucketName, objectName);
    }

    private String createPresignedObjectUrl(String bucketName, String objectName, String uploadId, int partNumber) {
        HashMap<String, String> extraQueryParams = new HashMap<String, String>();
        extraQueryParams.put("partNumber", String.valueOf(partNumber));
        extraQueryParams.put("uploadId", uploadId);
        GeneratePresignedUrlArguments arguments = new GeneratePresignedUrlArguments();
        arguments.setBucketName(bucketName);
        arguments.setObjectName(objectName);
        arguments.setMethod(HttpMethod.PUT);
        arguments.setExtraQueryParams(extraQueryParams);
        arguments.setExpiration(Duration.ofHours(1L));
        return this.ossObjectRepository.generatePresignedUrl(arguments);
    }

    private List<PartSummaryDomain> listParts(String bucketName, String objectName, String uploadId) {
        ListPartsDomain domain = this.ossMultipartUploadRepository.listParts(bucketName, objectName, uploadId);
        return domain.getParts();
    }

    public CreateMultipartUploadBusiness createMultipartUpload(String bucketName, String objectName, int totalParts) {
        String uploadId = this.createUploadId(bucketName, objectName);
        CreateMultipartUploadBusiness entity = new CreateMultipartUploadBusiness(uploadId);
        for (int i = 1; i <= totalParts; ++i) {
            String uploadUrl = this.createPresignedObjectUrl(bucketName, objectName, uploadId, i);
            entity.append(this.ossProxyAddressConverter.convert(uploadUrl));
        }
        return entity;
    }

    public CompleteMultipartUploadDomain completeMultipartUpload(String bucketName, String objectName, String uploadId) {
        List<PartSummaryDomain> parts = this.listParts(bucketName, objectName, uploadId);
        if (CollectionUtils.isNotEmpty(parts)) {
            return this.ossMultipartUploadRepository.completeMultipartUpload(bucketName, objectName, uploadId, parts);
        }
        return null;
    }
}

