/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.solution.proxy;

import cn.herodotus.oss.solution.properties.OssProxyProperties;
import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class OssProxyAddressConverter
implements Function<HttpServletRequest, String>,
Converter<String, String> {
    private static final Logger log = LoggerFactory.getLogger(OssProxyAddressConverter.class);
    private final OssProxyProperties ossProxyProperties;

    public OssProxyAddressConverter(OssProxyProperties ossProxyProperties) {
        this.ossProxyProperties = ossProxyProperties;
    }

    @Override
    public String apply(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String path = uri.replace("/oss/multipart-upload/presigned", "");
        String queryString = request.getQueryString();
        Object params = queryString != null ? "?" + queryString : "";
        String target = this.ossProxyProperties.getDestination() + path + (String)params;
        log.debug("[Herodotus] |- Convert request [{}] to [{}].", (Object)uri, (Object)target);
        return target;
    }

    public String convert(String source) {
        if (this.ossProxyProperties.getEnabled().booleanValue()) {
            String endpoint = this.ossProxyProperties.getSource() + "/oss/multipart-upload/presigned";
            String target = StringUtils.replace((String)source, (String)this.ossProxyProperties.getDestination(), (String)endpoint);
            log.debug("[Herodotus] |- Convert presignedObjectUrl [{}] to [{}].", (Object)endpoint, (Object)target);
            return target;
        }
        return source;
    }
}

