/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.rest.request.object;

import cn.herodotus.oss.definition.core.exception.OssConnectException;
import cn.herodotus.oss.definition.core.exception.OssIOException;
import cn.herodotus.oss.minio.rest.definition.PutObjectBaseRequest;
import io.minio.UploadObjectArgs;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import java.io.IOException;
import java.net.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(name="\u4e0a\u4f20\u5bf9\u8c61\u8bf7\u6c42\u53c2\u6570\u5b9e\u4f53")
public class UploadObjectRequest
extends PutObjectBaseRequest<UploadObjectArgs.Builder, UploadObjectArgs> {
    private static final Logger log = LoggerFactory.getLogger(UploadObjectRequest.class);
    @Schema(name="\u6587\u4ef6", description="\u53ef\u4ee5\u88ab\u8bbf\u95ee\u5230\u7684\uff0c\u5b8c\u6574\u7684\u6587\u4ef6\u8def\u5f84")
    @NotEmpty(message="filename \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotEmpty(message="filename \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a") String filename;

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public void prepare(UploadObjectArgs.Builder builder) {
        try {
            builder.filename(this.getFilename(), this.getPartSize().longValue());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in UploadObjectRequest.", (Throwable)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        builder.contentType(this.getContentType());
        super.prepare(builder);
    }

    @Override
    public UploadObjectArgs.Builder getBuilder() {
        return UploadObjectArgs.builder();
    }
}

