/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.rest.request.object;

import cn.herodotus.oss.minio.rest.definition.BucketRequest;
import io.minio.ListObjectsArgs;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

@Schema(name="\u5bf9\u8c61\u5217\u8868\u8bf7\u6c42\u53c2\u6570\u5b9e\u4f53", title="\u5bf9\u8c61\u5217\u8868\u8bf7\u6c42\u53c2\u6570\u5b9e\u4f53")
public class ListObjectsRequest
extends BucketRequest<ListObjectsArgs.Builder, ListObjectsArgs> {
    @Schema(name="\u5206\u9694\u7b26", description="\u5982\u679crecursive\u4e3atrue\uff0c\u90a3\u4e48\u9ed8\u8ba4\u503c\u4e3a'', \u5426\u5219\u9ed8\u8ba4\u503c\u4e3a'/'")
    private String delimiter = "";
    @Schema(name="\u4f7f\u7528UrlEncoding", description="\u9ed8\u8ba4\u5f00\u542f\uff0c\u9ed8\u8ba4\u503c\u4e3a true")
    private Boolean useUrlEncodingType = true;
    @Schema(name="\u5173\u952e\u5b57")
    private String keyMarker;
    @Min(value=1L, message="maxKeys \u503c\u4e0d\u80fd\u5c0f\u4e8e 1")
    @Max(value=1000L, message="maxKeys \u503c\u4e0d\u80fd\u5927\u4e8e 1000")
    @Schema(name="\u6700\u5927\u5173\u952e\u5b57\u6570\u91cf", description="\u5173\u952e\u5b57\u6570\u91cf\u5fc5\u987b\u5927\u4e8e1\uff0c\u540c\u65f6\u5c0f\u4e8e\u7b49\u4e8e1000, \u9ed8\u8ba4\u503c 1000")
    private @Min(value=1L, message="maxKeys \u503c\u4e0d\u80fd\u5c0f\u4e8e 1") @Max(value=1000L, message="maxKeys \u503c\u4e0d\u80fd\u5927\u4e8e 1000") Integer maxKeys = 1000;
    @Schema(name="\u524d\u7f00")
    private String prefix;
    @Schema(name="\u662f\u5426\u9012\u5f52", description="\u5f53\u524d\u9ed8\u8ba4\u8bbe\u7f6e\u4e3a false")
    private Boolean recursive;
    @Schema(name="\u662f\u5426\u4f7f\u7528V1 \u7248\u672cAPI", description="\u5f53\u524d\u9ed8\u8ba4\u8bbe\u7f6e\u4e3a true")
    private Boolean useApiVersion1;
    @Schema(name="\u662f\u5426\u5305\u542b\u7248\u672c\u4fe1\u606f", description="\u5f53\u524d\u9ed8\u8ba4\u8bbe\u7f6e\u4e3a false")
    private Boolean includeVersions;
    @Schema(name="\u6301\u7eed\u96c6\u6210Token", description="\u4ec5\u5f53\u4f7f\u7528 V2 \u7248\u672c API \u65f6\u9700\u8981\uff0c\u5373 useApiVersion1 == false")
    private String continuationToken;
    @Schema(name="\u83b7\u53d6Owner\u4fe1\u606f", description="\u4ec5\u5f53\u4f7f\u7528 V2 \u7248\u672c API \u65f6\u9700\u8981\uff0c\u5373 useApiVersion1 == false")
    private Boolean fetchOwner;
    @Schema(name="\u5305\u542b\u7528\u6237\u6269\u5c55\u81ea\u5b9a\u4e49\u4fe1\u606f", description="\u4ec5\u5f53\u4f7f\u7528 V2 \u7248\u672c API \u65f6\u9700\u8981\uff0c\u5373 useApiVersion1 == false")
    private Boolean includeUserMetadata;
    @Schema(name="\u7248\u672cID\u6807\u8bb0", description="\u4ec5\u5728GetObjectVersions\u60c5\u51b5\u4e0b\u4f7f\u7528")
    private String versionIdMarker;

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Boolean getUseUrlEncodingType() {
        return this.useUrlEncodingType;
    }

    public void setUseUrlEncodingType(Boolean useUrlEncodingType) {
        this.useUrlEncodingType = useUrlEncodingType;
    }

    public String getKeyMarker() {
        return this.keyMarker;
    }

    public void setKeyMarker(String keyMarker) {
        this.keyMarker = keyMarker;
    }

    public Integer getMaxKeys() {
        return this.maxKeys;
    }

    public void setMaxKeys(Integer maxKeys) {
        this.maxKeys = maxKeys;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Boolean getRecursive() {
        return this.recursive;
    }

    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }

    public Boolean getUseApiVersion1() {
        return this.useApiVersion1;
    }

    public void setUseApiVersion1(Boolean useApiVersion1) {
        this.useApiVersion1 = useApiVersion1;
    }

    public Boolean getIncludeVersions() {
        return this.includeVersions;
    }

    public void setIncludeVersions(Boolean includeVersions) {
        this.includeVersions = includeVersions;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public void setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public Boolean getFetchOwner() {
        return this.fetchOwner;
    }

    public void setFetchOwner(Boolean fetchOwner) {
        this.fetchOwner = fetchOwner;
    }

    public Boolean getIncludeUserMetadata() {
        return this.includeUserMetadata;
    }

    public void setIncludeUserMetadata(Boolean includeUserMetadata) {
        this.includeUserMetadata = includeUserMetadata;
    }

    public String getVersionIdMarker() {
        return this.versionIdMarker;
    }

    public void setVersionIdMarker(String versionIdMarker) {
        this.versionIdMarker = versionIdMarker;
    }

    @Override
    public void prepare(ListObjectsArgs.Builder builder) {
        builder.delimiter(this.getDelimiter());
        builder.useUrlEncodingType(this.getUseUrlEncodingType().booleanValue());
        builder.maxKeys(this.getMaxKeys().intValue());
        builder.prefix(this.getPrefix());
        if (ObjectUtils.isNotEmpty((Object)this.getRecursive())) {
            builder.recursive(this.getRecursive().booleanValue());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getKeyMarker())) {
            builder.keyMarker(this.getKeyMarker());
        }
        if (ObjectUtils.isNotEmpty((Object)this.getIncludeVersions())) {
            builder.recursive(this.getIncludeVersions().booleanValue());
        }
        if (BooleanUtils.isTrue((Boolean)this.getUseApiVersion1())) {
            builder.continuationToken(null);
            builder.fetchOwner(false);
            builder.includeUserMetadata(false);
        } else {
            if (StringUtils.isNotBlank((CharSequence)this.getContinuationToken())) {
                builder.continuationToken(this.getContinuationToken());
            }
            if (ObjectUtils.isNotEmpty((Object)this.getFetchOwner())) {
                builder.fetchOwner(this.getFetchOwner().booleanValue());
            }
            if (ObjectUtils.isNotEmpty((Object)this.getIncludeUserMetadata())) {
                builder.includeUserMetadata(this.getIncludeUserMetadata().booleanValue());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.getVersionIdMarker())) {
            builder.continuationToken(this.getVersionIdMarker());
        }
        super.prepare(builder);
    }

    @Override
    public ListObjectsArgs.Builder getBuilder() {
        return ListObjectsArgs.builder();
    }
}

