/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.rest.request.object;

import cn.herodotus.oss.minio.rest.converter.RequestToComposeSourceConverter;
import cn.herodotus.oss.minio.rest.definition.ObjectWriteRequest;
import cn.herodotus.oss.minio.rest.request.domain.ComposeSourceRequest;
import cn.herodotus.oss.minio.rest.request.object.CopyObjectRequest;
import io.minio.ComposeObjectArgs;
import io.minio.ComposeSource;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.core.convert.converter.Converter;

public class ComposeObjectRequest
extends ObjectWriteRequest<ComposeObjectArgs.Builder, ComposeObjectArgs> {
    private final Converter<ComposeSourceRequest, ComposeSource> requestTo = new RequestToComposeSourceConverter();
    private List<ComposeSourceRequest> sources;

    public ComposeObjectRequest(CopyObjectRequest request) {
        this.setExtraHeaders(request.getExtraHeaders());
        this.setExtraQueryParams(request.getExtraQueryParams());
        this.setBucketName(request.getBucketName());
        this.setRegion(request.getRegion());
        this.setObjectName(request.getObjectName());
        this.setHeaders(request.getHeaders());
        this.setUserMetadata(request.getUserMetadata());
        this.setServerSideEncryption(request.getServerSideEncryption());
        this.setTags(request.getTags());
        this.setRetention(request.getRetention());
        this.setLegalHold(request.getLegalHold());
        this.sources = new LinkedList<ComposeSourceRequest>();
        this.sources.add(new ComposeSourceRequest(request.getSource()));
    }

    public List<ComposeSourceRequest> getSources() {
        return this.sources;
    }

    public void setSources(List<ComposeSourceRequest> sources) {
        this.sources = sources;
    }

    @Override
    public void prepare(ComposeObjectArgs.Builder builder) {
        if (CollectionUtils.isNotEmpty(this.getSources())) {
            List<ComposeSource> composeSources = this.getSources().stream().map(arg_0 -> this.requestTo.convert(arg_0)).toList();
            builder.sources(composeSources);
        }
        super.prepare(builder);
    }

    @Override
    public ComposeObjectArgs.Builder getBuilder() {
        return ComposeObjectArgs.builder();
    }
}

