/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.rest.definition;

import cn.herodotus.oss.minio.core.converter.retention.DomainToRetentionConverter;
import cn.herodotus.oss.minio.core.converter.sse.RequestToServerSideEncryptionConverter;
import cn.herodotus.oss.minio.core.domain.RetentionDomain;
import cn.herodotus.oss.minio.core.domain.ServerSideEncryptionDomain;
import cn.herodotus.oss.minio.rest.definition.ObjectRequest;
import io.minio.ObjectWriteArgs;
import io.minio.ServerSideEncryption;
import io.minio.messages.Retention;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.core.convert.converter.Converter;

public abstract class ObjectWriteRequest<B extends ObjectWriteArgs.Builder<B, A>, A extends ObjectWriteArgs>
extends ObjectRequest<B, A> {
    private final Converter<RetentionDomain, Retention> toRetention = new DomainToRetentionConverter();
    private final Converter<ServerSideEncryptionDomain, ServerSideEncryption> toServerSideEncryption = new RequestToServerSideEncryptionConverter();
    @Schema(name="\u81ea\u5b9a\u4e49 Header \u4fe1\u606f")
    private Map<String, String> headers;
    @Schema(name="\u7528\u6237\u4fe1\u606f")
    private Map<String, String> userMetadata;
    @Schema(name="\u670d\u52a1\u7aef\u52a0\u5bc6")
    private ServerSideEncryptionDomain serverSideEncryption;
    @Schema(name="\u6807\u7b7e")
    private Map<String, String> tags;
    @Schema(name="\u4fdd\u7559\u914d\u7f6e")
    private RetentionDomain retention;
    @Schema(name="\u5408\u6cd5\u6301\u6709")
    private Boolean legalHold;

    public Converter<RetentionDomain, Retention> getToRetention() {
        return this.toRetention;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public ServerSideEncryptionDomain getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public void setServerSideEncryption(ServerSideEncryptionDomain serverSideEncryption) {
        this.serverSideEncryption = serverSideEncryption;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public RetentionDomain getRetention() {
        return this.retention;
    }

    public void setRetention(RetentionDomain retention) {
        this.retention = retention;
    }

    public Boolean getLegalHold() {
        return this.legalHold;
    }

    public void setLegalHold(Boolean legalHold) {
        this.legalHold = legalHold;
    }

    @Override
    public void prepare(B builder) {
        ServerSideEncryption encryption;
        if (MapUtils.isNotEmpty(this.getHeaders())) {
            builder.headers(this.getHeaders());
        }
        if (MapUtils.isNotEmpty(this.getUserMetadata())) {
            builder.headers(this.getUserMetadata());
        }
        if (MapUtils.isNotEmpty(this.getTags())) {
            builder.headers(this.getTags());
        }
        builder.tags(this.getTags());
        if (ObjectUtils.isNotEmpty((Object)this.getServerSideEncryption()) && ObjectUtils.isNotEmpty((Object)(encryption = (ServerSideEncryption)this.toServerSideEncryption.convert((Object)this.getServerSideEncryption())))) {
            builder.sse(encryption);
        }
        if (ObjectUtils.isNotEmpty((Object)this.getRetention())) {
            builder.retention((Retention)this.toRetention.convert((Object)this.getRetention()));
        }
        if (ObjectUtils.isNotEmpty((Object)this.getLegalHold())) {
            builder.legalHold(this.getLegalHold().booleanValue());
        }
        super.prepare(builder);
    }
}

