/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.rest.controller;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.rest.core.annotation.AccessLimited;
import cn.herodotus.engine.rest.core.annotation.Idempotent;
import cn.herodotus.engine.rest.core.controller.Controller;
import cn.herodotus.oss.minio.core.converter.BucketToDomainConverter;
import cn.herodotus.oss.minio.core.domain.BucketDomain;
import cn.herodotus.oss.minio.core.utils.ConverterUtils;
import cn.herodotus.oss.minio.logic.service.MinioBucketService;
import cn.herodotus.oss.minio.rest.request.bucket.BucketExistsRequest;
import cn.herodotus.oss.minio.rest.request.bucket.ListBucketsRequest;
import cn.herodotus.oss.minio.rest.request.bucket.MakeBucketRequest;
import cn.herodotus.oss.minio.rest.request.bucket.RemoveBucketRequest;
import io.minio.BucketExistsArgs;
import io.minio.ListBucketsArgs;
import io.minio.MakeBucketArgs;
import io.minio.RemoveBucketArgs;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oss/minio/bucket"})
@Tags(value={@Tag(name="\u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5b58\u50a8\u6876\u7ba1\u7406\u63a5\u53e3")})
public class MinioBucketController
implements Controller {
    private final MinioBucketService minioBucketService;

    public MinioBucketController(MinioBucketService minioBucketService) {
        this.minioBucketService = minioBucketService;
    }

    @AccessLimited
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u5b58\u50a8\u6876(Bucket)", description="\u83b7\u53d6\u5168\u90e8\u5b58\u50a8\u6876(Bucket)", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u6240\u6709Buckets", content={@Content(mediaType="application/json", schema=@Schema(implementation=List.class))}), @ApiResponse(responseCode="200", description="\u67e5\u8be2\u6210\u529f\uff0c\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="204", description="\u67e5\u8be2\u6210\u529f\uff0c\u672a\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="500", description="\u67e5\u8be2\u5931\u8d25"), @ApiResponse(responseCode="503", description="Minio Server\u65e0\u6cd5\u8bbf\u95ee\u6216\u672a\u542f\u52a8")})
    @Parameters(value={@Parameter(name="request", required=true, description="ListBucketsRequest\u8bf7\u6c42\u53c2\u6570\u5bf9\u8c61", schema=@Schema(implementation=ListBucketsRequest.class))})
    @GetMapping(value={"/list"})
    public Result<List<BucketDomain>> list(ListBucketsRequest request) {
        List buckets = this.minioBucketService.listBuckets(ObjectUtils.isNotEmpty((Object)request) ? (ListBucketsArgs)request.build() : null);
        List domains = ConverterUtils.toDomains((List)buckets, (Converter)new BucketToDomainConverter());
        return this.result(domains);
    }

    @AccessLimited
    @Operation(summary="\u67e5\u8be2\u5b58\u50a8\u6876\u662f\u5426\u5b58\u5728", description="\u6839\u636eBucketName\u548cRegion\u67e5\u8be2\u5b58\u50a8\u6876\u662f\u5426\u5b58\u5728", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u662f\u5426Bucket\u5b58\u5728", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="200", description="\u67e5\u8be2\u6210\u529f"), @ApiResponse(responseCode="500", description="\u67e5\u8be2\u5931\u8d25"), @ApiResponse(responseCode="503", description="Minio Server\u65e0\u6cd5\u8bbf\u95ee\u6216\u672a\u542f\u52a8")})
    @Parameters(value={@Parameter(name="request", required=true, description="BucketExistsRequest\u8bf7\u6c42\u5b9e\u4f53", schema=@Schema(implementation=BucketExistsRequest.class))})
    @GetMapping(value={"/exists"})
    public Result<Boolean> exists(BucketExistsRequest request) {
        boolean isExists = this.minioBucketService.bucketExists((BucketExistsArgs)request.build());
        return this.result(isExists);
    }

    @Idempotent
    @Operation(summary="\u521b\u5efa\u5b58\u50a8\u6876", description="\u521b\u5efa\u5b58\u50a8\u6876\u63a5\u53e3\uff0c\u8be5\u63a5\u53e3\u4ec5\u662f\u521b\u5efa\uff0c\u4e0d\u5305\u542b\u662f\u5426\u5df2\u5b58\u5728\u68c0\u67e5", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="Minio API \u65e0\u8fd4\u56de\u503c\uff0c\u6240\u4ee5\u8fd4\u56de200\u5373\u8868\u793a\u6210\u529f\uff0c\u4e0d\u6210\u529f\u4f1a\u629b\u9519", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="200", description="\u64cd\u4f5c\u6210\u529f"), @ApiResponse(responseCode="500", description="\u64cd\u4f5c\u5931\u8d25\uff0c\u5177\u4f53\u67e5\u770b\u9519\u8bef\u4fe1\u606f\u5185\u5bb9"), @ApiResponse(responseCode="503", description="Minio Server\u65e0\u6cd5\u8bbf\u95ee\u6216\u672a\u542f\u52a8")})
    @Parameters(value={@Parameter(name="request", required=true, description="MakeBucketRequest\u8bf7\u6c42\u53c2\u6570\u5b9e\u4f53", schema=@Schema(implementation=MakeBucketRequest.class))})
    @PostMapping
    public Result<Boolean> make(@Validated @RequestBody MakeBucketRequest request) {
        this.minioBucketService.makeBucket((MakeBucketArgs)request.build());
        return this.result(true);
    }

    @Idempotent
    @Operation(summary="\u5220\u9664\u5b58\u50a8\u6876", description="\u6839\u636e\u5b58\u50a8\u6876\u540d\u79f0\u5220\u9664\u6570\u636e\uff0c\u53ef\u6307\u5b9a Region", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="Minio API \u65e0\u8fd4\u56de\u503c\uff0c\u6240\u4ee5\u8fd4\u56de200\u5373\u8868\u793a\u6210\u529f\uff0c\u4e0d\u6210\u529f\u4f1a\u629b\u9519", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="200", description="\u64cd\u4f5c\u6210\u529f"), @ApiResponse(responseCode="500", description="\u64cd\u4f5c\u5931\u8d25\uff0c\u5177\u4f53\u67e5\u770b\u9519\u8bef\u4fe1\u606f\u5185\u5bb9"), @ApiResponse(responseCode="503", description="Minio Server \u65e0\u6cd5\u8bbf\u95ee\u6216\u672a\u542f\u52a8")})
    @Parameters(value={@Parameter(name="request", required=true, description="RemoveBucketRequest\u8bf7\u6c42\u53c2\u6570\u5b9e\u4f53", schema=@Schema(implementation=RemoveBucketRequest.class))})
    @DeleteMapping
    public Result<Boolean> remove(@Validated @RequestBody RemoveBucketRequest request) {
        this.minioBucketService.removeBucket((RemoveBucketArgs)request.build());
        return this.result(true);
    }
}

