/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.logic.service;

import cn.herodotus.oss.definition.core.exception.OssConnectException;
import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.minio.core.exception.MinioErrorResponseException;
import cn.herodotus.oss.minio.core.exception.MinioIOException;
import cn.herodotus.oss.minio.core.exception.MinioInsufficientDataException;
import cn.herodotus.oss.minio.core.exception.MinioInternalException;
import cn.herodotus.oss.minio.core.exception.MinioInvalidKeyException;
import cn.herodotus.oss.minio.core.exception.MinioInvalidResponseException;
import cn.herodotus.oss.minio.core.exception.MinioNoSuchAlgorithmException;
import cn.herodotus.oss.minio.core.exception.MinioXmlParserException;
import cn.herodotus.oss.minio.logic.definition.pool.MinioClientObjectPool;
import cn.herodotus.oss.minio.logic.definition.service.BaseMinioClientService;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MinioClient;
import io.minio.PostPolicy;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import java.io.IOException;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MinioPresignedObjectUrlService
extends BaseMinioClientService {
    private static final Logger log = LoggerFactory.getLogger(MinioPresignedObjectUrlService.class);

    public MinioPresignedObjectUrlService(MinioClientObjectPool minioClientObjectPool) {
        super(minioClientObjectPool);
    }

    public Map<String, String> getPresignedPostFormData(PostPolicy postPolicy) {
        String function = "getPresignedPostFormData";
        MinioClient minioClient = this.getMinioClient();
        try {
            Map map = minioClient.getPresignedPostFormData(postPolicy);
            return map;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new MinioInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new MinioInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new MinioIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new MinioNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new MinioXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }

    public String getPresignedObjectUrl(String bucketName, String objectName) {
        return this.getPresignedObjectUrl(bucketName, null, objectName);
    }

    public String getPresignedObjectUrl(String bucketName, String region, String objectName) {
        return this.getPresignedObjectUrl(bucketName, region, objectName, Method.GET);
    }

    public String getPresignedObjectUrl(String bucketName, String region, String objectName, Method method) {
        return this.getPresignedObjectUrl(bucketName, region, objectName, method, 7, TimeUnit.DAYS);
    }

    public String getPresignedObjectUrl(String bucketName, String region, String objectName, Method method, int duration, TimeUnit unit) {
        return this.getPresignedObjectUrl(bucketName, region, objectName, method, duration, unit, null);
    }

    public String getPresignedObjectUrl(String bucketName, String region, String objectName, Method method, int duration, TimeUnit unit, String versionId) {
        return this.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucketName)).region(region)).object(objectName)).method(method).expiry(duration, unit).versionId(versionId)).build());
    }

    public String getPresignedObjectUrl(GetPresignedObjectUrlArgs getPresignedObjectUrlArgs) {
        String function = "getPresignedObjectUrl";
        MinioClient minioClient = this.getMinioClient();
        try {
            String string = minioClient.getPresignedObjectUrl(getPresignedObjectUrlArgs);
            return string;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new MinioInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new MinioInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new MinioIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new MinioNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new MinioXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }
}

