/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.logic.service;

import cn.herodotus.oss.definition.core.exception.OssConnectException;
import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.minio.core.converter.retention.RetentionToDomainConverter;
import cn.herodotus.oss.minio.core.domain.RetentionDomain;
import cn.herodotus.oss.minio.core.exception.MinioErrorResponseException;
import cn.herodotus.oss.minio.core.exception.MinioIOException;
import cn.herodotus.oss.minio.core.exception.MinioInsufficientDataException;
import cn.herodotus.oss.minio.core.exception.MinioInternalException;
import cn.herodotus.oss.minio.core.exception.MinioInvalidKeyException;
import cn.herodotus.oss.minio.core.exception.MinioInvalidResponseException;
import cn.herodotus.oss.minio.core.exception.MinioNoSuchAlgorithmException;
import cn.herodotus.oss.minio.core.exception.MinioXmlParserException;
import cn.herodotus.oss.minio.logic.definition.pool.MinioClientObjectPool;
import cn.herodotus.oss.minio.logic.definition.service.BaseMinioClientService;
import io.minio.GetObjectRetentionArgs;
import io.minio.MinioClient;
import io.minio.SetObjectRetentionArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Retention;
import java.io.IOException;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;

@Service
public class MinioObjectRetentionService
extends BaseMinioClientService {
    private static final Logger log = LoggerFactory.getLogger(MinioObjectRetentionService.class);
    private final Converter<Retention, RetentionDomain> toDo = new RetentionToDomainConverter();

    public MinioObjectRetentionService(MinioClientObjectPool minioClientObjectPool) {
        super(minioClientObjectPool);
    }

    public RetentionDomain getObjectRetention(String bucketName, String objectName) {
        return this.getObjectRetention(bucketName, null, objectName);
    }

    public RetentionDomain getObjectRetention(String bucketName, String region, String objectName) {
        return this.getObjectRetention(bucketName, region, objectName, null);
    }

    public RetentionDomain getObjectRetention(String bucketName, String region, String objectName, String versionId) {
        return this.getObjectRetention((GetObjectRetentionArgs)((GetObjectRetentionArgs.Builder)((GetObjectRetentionArgs.Builder)((GetObjectRetentionArgs.Builder)((GetObjectRetentionArgs.Builder)GetObjectRetentionArgs.builder().bucket(bucketName)).region(region)).object(objectName)).versionId(versionId)).build());
    }

    public RetentionDomain getObjectRetention(GetObjectRetentionArgs getObjectRetentionArgs) {
        String function = "getObjectRetention";
        MinioClient minioClient = this.getMinioClient();
        try {
            Retention retention = minioClient.getObjectRetention(getObjectRetentionArgs);
            RetentionDomain retentionDomain = (RetentionDomain)this.toDo.convert((Object)retention);
            return retentionDomain;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new MinioInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new MinioInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new MinioIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new MinioNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new MinioXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }

    public void setObjectRetention(String bucketName, String objectName, Retention config) {
        this.setObjectRetention(bucketName, objectName, config, false);
    }

    public void setObjectRetention(String bucketName, String objectName, Retention config, boolean bypassGovernanceMode) {
        this.setObjectRetention(bucketName, null, objectName, config, bypassGovernanceMode);
    }

    public void setObjectRetention(String bucketName, String region, String objectName, Retention config, boolean bypassGovernanceMode) {
        this.setObjectRetention(bucketName, region, objectName, config, bypassGovernanceMode, null);
    }

    public void setObjectRetention(String bucketName, String region, String objectName, Retention config, boolean bypassGovernanceMode, String versionId) {
        this.setObjectRetention((SetObjectRetentionArgs)((SetObjectRetentionArgs.Builder)((SetObjectRetentionArgs.Builder)((SetObjectRetentionArgs.Builder)((SetObjectRetentionArgs.Builder)SetObjectRetentionArgs.builder().bucket(bucketName)).region(region)).object(objectName)).config(config).bypassGovernanceMode(bypassGovernanceMode).versionId(versionId)).build());
    }

    public void setObjectRetention(SetObjectRetentionArgs setObjectRetentionArgs) {
        String function = "setObjectRetention";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.setObjectRetention(setObjectRetentionArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new MinioInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new MinioInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new MinioIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new MinioNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new MinioXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }
}

