/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.logic.service;

import cn.herodotus.oss.definition.core.exception.OssConnectException;
import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.minio.core.converter.retention.ObjectLockConfigurationToDomainConverter;
import cn.herodotus.oss.minio.core.domain.ObjectLockConfigurationDomain;
import cn.herodotus.oss.minio.core.exception.MinioErrorResponseException;
import cn.herodotus.oss.minio.core.exception.MinioIOException;
import cn.herodotus.oss.minio.core.exception.MinioInsufficientDataException;
import cn.herodotus.oss.minio.core.exception.MinioInternalException;
import cn.herodotus.oss.minio.core.exception.MinioInvalidKeyException;
import cn.herodotus.oss.minio.core.exception.MinioInvalidResponseException;
import cn.herodotus.oss.minio.core.exception.MinioNoSuchAlgorithmException;
import cn.herodotus.oss.minio.core.exception.MinioXmlParserException;
import cn.herodotus.oss.minio.logic.definition.pool.MinioClientObjectPool;
import cn.herodotus.oss.minio.logic.definition.service.BaseMinioClientService;
import io.minio.DeleteObjectLockConfigurationArgs;
import io.minio.GetObjectLockConfigurationArgs;
import io.minio.MinioClient;
import io.minio.SetObjectLockConfigurationArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.ObjectLockConfiguration;
import java.io.IOException;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;

@Service
public class MinioObjectLockConfigurationService
extends BaseMinioClientService {
    private static final Logger log = LoggerFactory.getLogger(MinioObjectLockConfigurationService.class);
    private final Converter<ObjectLockConfiguration, ObjectLockConfigurationDomain> toDo = new ObjectLockConfigurationToDomainConverter();

    public MinioObjectLockConfigurationService(MinioClientObjectPool minioClientObjectPool) {
        super(minioClientObjectPool);
    }

    public ObjectLockConfiguration getObjectLockConfiguration(String bucketName) {
        return this.getObjectLockConfiguration(bucketName, null);
    }

    public ObjectLockConfiguration getObjectLockConfiguration(String bucketName, String region) {
        return this.getObjectLockConfiguration((GetObjectLockConfigurationArgs)((GetObjectLockConfigurationArgs.Builder)((GetObjectLockConfigurationArgs.Builder)GetObjectLockConfigurationArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public ObjectLockConfiguration getObjectLockConfiguration(GetObjectLockConfigurationArgs getObjectLockConfigurationArgs) {
        String function = "getObjectLockConfiguration";
        MinioClient minioClient = this.getMinioClient();
        try {
            ObjectLockConfiguration objectLockConfiguration = minioClient.getObjectLockConfiguration(getObjectLockConfigurationArgs);
            return objectLockConfiguration;
        }
        catch (ErrorResponseException e) {
            ObjectLockConfiguration objectLockConfiguration = null;
            return objectLockConfiguration;
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new MinioInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new MinioInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new MinioIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new MinioNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in createBucket.", (Throwable)e);
            throw new MinioXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }

    public void setObjectLockConfiguration(String bucketName, ObjectLockConfiguration config) {
        this.setObjectLockConfiguration(bucketName, null, config);
    }

    public void setObjectLockConfiguration(String bucketName, String region, ObjectLockConfiguration config) {
        this.setObjectLockConfiguration((SetObjectLockConfigurationArgs)((SetObjectLockConfigurationArgs.Builder)((SetObjectLockConfigurationArgs.Builder)SetObjectLockConfigurationArgs.builder().bucket(bucketName)).region(region)).config(config).build());
    }

    public void setObjectLockConfiguration(SetObjectLockConfigurationArgs setObjectLockConfigurationArgs) {
        String function = "setObjectLockConfiguration";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.setObjectLockConfiguration(setObjectLockConfigurationArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new MinioInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new MinioInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new MinioIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new MinioNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new MinioXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }

    public void deleteObjectLockConfiguration(String bucketName) {
        this.deleteObjectLockConfiguration(bucketName, null);
    }

    public void deleteObjectLockConfiguration(String bucketName, String region) {
        this.deleteObjectLockConfiguration((DeleteObjectLockConfigurationArgs)((DeleteObjectLockConfigurationArgs.Builder)((DeleteObjectLockConfigurationArgs.Builder)DeleteObjectLockConfigurationArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public void deleteObjectLockConfiguration(DeleteObjectLockConfigurationArgs deleteObjectLockConfigurationArgs) {
        String function = "deleteObjectLockConfiguration";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.deleteObjectLockConfiguration(deleteObjectLockConfigurationArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new MinioInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new MinioInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new MinioIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new MinioNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new MinioXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }
}

