/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.logic.service;

import cn.herodotus.oss.definition.core.exception.OssConnectException;
import cn.herodotus.oss.definition.core.exception.OssServerException;
import cn.herodotus.oss.minio.core.exception.MinioErrorResponseException;
import cn.herodotus.oss.minio.core.exception.MinioIOException;
import cn.herodotus.oss.minio.core.exception.MinioInsufficientDataException;
import cn.herodotus.oss.minio.core.exception.MinioInternalException;
import cn.herodotus.oss.minio.core.exception.MinioInvalidKeyException;
import cn.herodotus.oss.minio.core.exception.MinioInvalidResponseException;
import cn.herodotus.oss.minio.core.exception.MinioNoSuchAlgorithmException;
import cn.herodotus.oss.minio.core.exception.MinioXmlParserException;
import cn.herodotus.oss.minio.logic.definition.pool.MinioClientObjectPool;
import cn.herodotus.oss.minio.logic.definition.service.BaseMinioClientService;
import io.minio.DeleteBucketNotificationArgs;
import io.minio.GetBucketNotificationArgs;
import io.minio.MinioClient;
import io.minio.SetBucketNotificationArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.NotificationConfiguration;
import java.io.IOException;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MinioBucketNotificationService
extends BaseMinioClientService {
    private static final Logger log = LoggerFactory.getLogger(MinioBucketNotificationService.class);

    public MinioBucketNotificationService(MinioClientObjectPool minioClientObjectPool) {
        super(minioClientObjectPool);
    }

    public void setBucketNotification(String bucketName, NotificationConfiguration notificationConfiguration) {
        this.setBucketNotification((SetBucketNotificationArgs)((SetBucketNotificationArgs.Builder)SetBucketNotificationArgs.builder().bucket(bucketName)).config(notificationConfiguration).build());
    }

    public void setBucketNotification(String bucketName, String region, NotificationConfiguration notificationConfiguration) {
        this.setBucketNotification((SetBucketNotificationArgs)((SetBucketNotificationArgs.Builder)((SetBucketNotificationArgs.Builder)SetBucketNotificationArgs.builder().bucket(bucketName)).region(region)).config(notificationConfiguration).build());
    }

    public void setBucketNotification(SetBucketNotificationArgs setBucketNotificationArgs) {
        String function = "setBucketNotification";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.setBucketNotification(setBucketNotificationArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new MinioInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new MinioInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new MinioIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new MinioNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new MinioXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }

    public NotificationConfiguration getBucketNotification(String bucketName) {
        return this.getBucketNotification((GetBucketNotificationArgs)((GetBucketNotificationArgs.Builder)GetBucketNotificationArgs.builder().bucket(bucketName)).build());
    }

    public NotificationConfiguration getBucketNotification(String bucketName, String region) {
        return this.getBucketNotification((GetBucketNotificationArgs)((GetBucketNotificationArgs.Builder)((GetBucketNotificationArgs.Builder)GetBucketNotificationArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public NotificationConfiguration getBucketNotification(GetBucketNotificationArgs getBucketNotificationArgs) {
        String function = "getBucketNotification";
        MinioClient minioClient = this.getMinioClient();
        try {
            NotificationConfiguration notificationConfiguration = minioClient.getBucketNotification(getBucketNotificationArgs);
            return notificationConfiguration;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new MinioInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new MinioInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new MinioIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new MinioNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in createBucket.", (Throwable)e);
            throw new MinioXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }

    public void deleteBucketNotification(String bucketName) {
        this.deleteBucketNotification((DeleteBucketNotificationArgs)((DeleteBucketNotificationArgs.Builder)DeleteBucketNotificationArgs.builder().bucket(bucketName)).build());
    }

    public void deleteBucketNotification(String bucketName, String region) {
        this.deleteBucketNotification((DeleteBucketNotificationArgs)((DeleteBucketNotificationArgs.Builder)((DeleteBucketNotificationArgs.Builder)DeleteBucketNotificationArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public void deleteBucketNotification(DeleteBucketNotificationArgs deleteBucketNotificationArgs) {
        String function = "deleteBucketNotification";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.deleteBucketNotification(deleteBucketNotificationArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new MinioInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new MinioInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new MinioIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new MinioNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in createBucket.", (Throwable)e);
            throw new MinioXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }
}

