/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.logic.service;

import cn.herodotus.oss.definition.core.exception.OssConnectException;
import cn.herodotus.oss.minio.core.exception.MinioIOException;
import cn.herodotus.oss.minio.core.exception.MinioInvalidCipherTextException;
import cn.herodotus.oss.minio.core.exception.MinioInvalidKeyException;
import cn.herodotus.oss.minio.core.exception.MinioNoSuchAlgorithmException;
import cn.herodotus.oss.minio.logic.definition.pool.MinioAdminClientObjectPool;
import cn.herodotus.oss.minio.logic.definition.service.BaseMinioAdminClientService;
import io.minio.admin.MinioAdminClient;
import io.minio.admin.UserInfo;
import java.io.IOException;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MinioAdminUserService
extends BaseMinioAdminClientService {
    private static final Logger log = LoggerFactory.getLogger(MinioAdminUserService.class);

    public MinioAdminUserService(MinioAdminClientObjectPool minioAdminClientObjectPool) {
        super(minioAdminClientObjectPool);
    }

    public Map<String, UserInfo> listUsers() {
        String function = "listUsers";
        MinioAdminClient minioAdminClient = this.getMinioAdminClient();
        try {
            Map map = minioAdminClient.listUsers();
            return map;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new MinioNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new MinioIOException(e.getMessage());
        }
        catch (InvalidCipherTextException e) {
            log.error("[Herodotus] |- Minio catch InvalidCipherTextException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidCipherTextException(e.getMessage());
        }
        finally {
            this.close(minioAdminClient);
        }
    }

    public UserInfo getUserInfo(String accessKey) {
        String function = "getUserInfo";
        MinioAdminClient minioAdminClient = this.getMinioAdminClient();
        try {
            UserInfo userInfo = minioAdminClient.getUserInfo(accessKey);
            return userInfo;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new MinioNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new MinioIOException(e.getMessage());
        }
        finally {
            this.close(minioAdminClient);
        }
    }

    public void addUser(@Nonnull String accessKey, @Nonnull UserInfo.Status status, @Nullable String secretKey, @Nullable String policyName, @Nullable List<String> memberOf) {
        String function = "addUser";
        MinioAdminClient minioAdminClient = this.getMinioAdminClient();
        try {
            minioAdminClient.addUser(accessKey, status, secretKey, policyName, memberOf);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new MinioNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new MinioIOException(e.getMessage());
        }
        catch (InvalidCipherTextException e) {
            log.error("[Herodotus] |- Minio catch InvalidCipherTextException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidCipherTextException(e.getMessage());
        }
        finally {
            this.close(minioAdminClient);
        }
    }

    public void deleteUser(@Nonnull String accessKey) {
        String function = "deleteUser";
        MinioAdminClient minioAdminClient = this.getMinioAdminClient();
        try {
            minioAdminClient.deleteUser(accessKey);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new MinioNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new MinioInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new MinioIOException(e.getMessage());
        }
        finally {
            this.close(minioAdminClient);
        }
    }
}

