/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.logic.definition.pool;

import cn.herodotus.oss.minio.logic.properties.MinioProperties;
import io.minio.admin.MinioAdminClient;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioAdminClientPooledObjectFactory
extends BasePooledObjectFactory<MinioAdminClient> {
    private static final Logger log = LoggerFactory.getLogger(MinioAdminClientPooledObjectFactory.class);
    private final MinioProperties minioProperties;

    public MinioAdminClientPooledObjectFactory(MinioProperties minioProperties) {
        this.minioProperties = minioProperties;
    }

    public MinioAdminClient create() throws Exception {
        log.debug("[Herodotus] |- Minio admin client factory create object.");
        return MinioAdminClient.builder().endpoint(this.minioProperties.getEndpoint()).credentials(this.minioProperties.getAccessKey(), this.minioProperties.getSecretKey()).build();
    }

    public PooledObject<MinioAdminClient> wrap(MinioAdminClient minioAdminClient) {
        log.debug("[Herodotus] |- Minio admin client factory wrap object.");
        return new DefaultPooledObject((Object)minioAdminClient);
    }
}

