/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.logic.definition.pool;

import cn.herodotus.oss.definition.core.exception.OssClientPoolErrorException;
import cn.herodotus.oss.minio.logic.definition.pool.MinioAdminClientPooledObjectFactory;
import cn.herodotus.oss.minio.logic.properties.MinioProperties;
import io.minio.admin.MinioAdminClient;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioAdminClientObjectPool {
    private static final Logger log = LoggerFactory.getLogger(MinioAdminClientObjectPool.class);
    private final GenericObjectPool<MinioAdminClient> genericObjectPool;

    public MinioAdminClientObjectPool(MinioProperties minioProperties) {
        MinioAdminClientPooledObjectFactory factory = new MinioAdminClientPooledObjectFactory(minioProperties);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(minioProperties.getPool().getMaxTotal().intValue());
        config.setMaxIdle(minioProperties.getPool().getMaxIdle().intValue());
        config.setMinIdle(minioProperties.getPool().getMinIdle().intValue());
        config.setMaxWait(minioProperties.getPool().getMaxWait());
        config.setMinEvictableIdleTime(minioProperties.getPool().getMinEvictableIdleTime());
        config.setSoftMinEvictableIdleTime(minioProperties.getPool().getSoftMinEvictableIdleTime());
        config.setLifo(minioProperties.getPool().getLifo().booleanValue());
        config.setBlockWhenExhausted(minioProperties.getPool().getBlockWhenExhausted().booleanValue());
        this.genericObjectPool = new GenericObjectPool((PooledObjectFactory)factory, config);
    }

    public MinioAdminClient getMinioAdminClient() {
        try {
            MinioAdminClient minioAdminClient = (MinioAdminClient)this.genericObjectPool.borrowObject();
            log.debug("[Herodotus] |- Fetch minio admin client from object pool.");
            return minioAdminClient;
        }
        catch (Exception e) {
            log.error("[Herodotus] |- Can not fetch minio admin client from pool.", (Throwable)e);
            throw new OssClientPoolErrorException("Can not fetch minio admin client from pool.");
        }
    }

    public void close(MinioAdminClient minioAdminClient) {
        if (ObjectUtils.isNotEmpty((Object)minioAdminClient)) {
            log.debug("[Herodotus] |- Close minio admin client.");
            this.genericObjectPool.returnObject((Object)minioAdminClient);
        }
    }
}

