/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.logic.configuration;

import cn.herodotus.oss.minio.logic.definition.pool.MinioAdminClientObjectPool;
import cn.herodotus.oss.minio.logic.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.oss.minio.logic.definition.pool.MinioClientObjectPool;
import cn.herodotus.oss.minio.logic.properties.MinioProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class MinioClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MinioClientConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Minio Client] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public MinioClientObjectPool minioClientPool(MinioProperties minioProperties) {
        MinioClientObjectPool minioClientObjectPool = new MinioClientObjectPool(minioProperties);
        log.trace("[Herodotus] |- Bean [Minio Client Pool] Auto Configure.");
        return minioClientObjectPool;
    }

    @Bean
    @ConditionalOnMissingBean
    public MinioAsyncClientObjectPool minioAsyncClientPool(MinioProperties minioProperties) {
        MinioAsyncClientObjectPool minioAsyncClientObjectPool = new MinioAsyncClientObjectPool(minioProperties);
        log.trace("[Herodotus] |- Bean [Minio Async Client Pool] Auto Configure.");
        return minioAsyncClientObjectPool;
    }

    @Bean
    @ConditionalOnMissingBean
    public MinioAdminClientObjectPool minioAdminClientPool(MinioProperties minioProperties) {
        MinioAdminClientObjectPool minioAdminClientObjectPool = new MinioAdminClientObjectPool(minioProperties);
        log.trace("[Herodotus] |- Bean [Minio Admin Client Pool] Auto Configure.");
        return minioAdminClientObjectPool;
    }
}

