/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.logic.processor;

import cn.herodotus.oss.minio.api.properties.MinioProperties;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MinioProxyAddressConverter {
    private static final Logger log = LoggerFactory.getLogger(MinioProxyAddressConverter.class);
    private final MinioProperties minioProperties;

    public MinioProxyAddressConverter(MinioProperties minioProperties) {
        this.minioProperties = minioProperties;
    }

    public String toServiceUrl(String presignedObjectUrl) {
        if (this.minioProperties.getOpenProxy().booleanValue()) {
            String endpoint = this.minioProperties.getServerEndpoint() + "/oss/minio/multipart/presigned";
            String target = StringUtils.replace((String)presignedObjectUrl, (String)this.minioProperties.getEndpoint(), (String)endpoint);
            log.debug("[Herodotus] |- Convert presignedObjectUrl [{}] to [{}].", (Object)endpoint, (Object)target);
            return target;
        }
        return presignedObjectUrl;
    }

    public String toPresignedObjectUrl(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String path = uri.replace("/oss/minio/multipart/presigned", "");
        String queryString = request.getQueryString();
        Object params = queryString != null ? "?" + queryString : "";
        String target = this.minioProperties.getEndpoint() + path + (String)params;
        log.debug("[Herodotus] |- Convert request [{}] to [{}].", (Object)uri, (Object)target);
        return target;
    }
}

