/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.minio.logic.processor;

import cn.herodotus.oss.minio.logic.processor.MinioProxyAddressConverter;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.RestTemplate;

@Component
public class MinioPresignedObjectUrlProxy {
    private final MinioProxyAddressConverter converter;
    private final RestTemplate restTemplate;

    public MinioPresignedObjectUrlProxy(MinioProxyAddressConverter converter, RestTemplate restTemplate) {
        this.converter = converter;
        this.restTemplate = restTemplate;
    }

    public ResponseEntity<String> delegate(HttpServletRequest request) {
        try {
            String target = this.converter.toPresignedObjectUrl(request);
            RequestEntity<byte[]> requestEntity = this.createRequestEntity(request, target);
            return this.restTemplate.exchange(requestEntity, String.class);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)"Delegate ERROR", (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private RequestEntity<byte[]> createRequestEntity(HttpServletRequest request, String url) throws URISyntaxException, IOException {
        String method = request.getMethod();
        HttpMethod httpMethod = method != null ? HttpMethod.valueOf((String)method) : null;
        MultiValueMap<String, String> headers = this.readRequestHeader(request);
        byte[] body = this.readRequestBody(request);
        return new RequestEntity((Object)body, headers, httpMethod, new URI(url));
    }

    private byte[] readRequestBody(HttpServletRequest request) throws IOException {
        ServletInputStream inputStream = request.getInputStream();
        return StreamUtils.copyToByteArray((InputStream)inputStream);
    }

    private MultiValueMap<String, String> readRequestHeader(HttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        ArrayList<String> headerNames = Collections.list(request.getHeaderNames());
        for (String headerName : headerNames) {
            ArrayList<String> headerValues = Collections.list(request.getHeaders(headerName));
            for (String headerValue : headerValues) {
                headers.add(headerName, headerValue);
            }
        }
        return headers;
    }
}

