/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.service;

import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.s3.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteBucketAnalyticsConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketAnalyticsConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketAnalyticsConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketAnalyticsConfigurationResult;
import com.amazonaws.services.s3.model.ListBucketAnalyticsConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketAnalyticsConfigurationsResult;
import com.amazonaws.services.s3.model.SetBucketAnalyticsConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketAnalyticsConfigurationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3BucketAnalyticsConfigurationService
extends BaseS3Service {
    private static final Logger log = LoggerFactory.getLogger(S3BucketAnalyticsConfigurationService.class);

    public S3BucketAnalyticsConfigurationService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public DeleteBucketAnalyticsConfigurationResult deleteBucketAnalyticsConfiguration(DeleteBucketAnalyticsConfigurationRequest request) {
        String function = "deleteBucketAnalyticsConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            DeleteBucketAnalyticsConfigurationResult deleteBucketAnalyticsConfigurationResult = amazonS3.deleteBucketAnalyticsConfiguration(request);
            return deleteBucketAnalyticsConfigurationResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public GetBucketAnalyticsConfigurationResult getBucketAnalyticsConfiguration(GetBucketAnalyticsConfigurationRequest request) {
        String function = "getBucketAnalyticsConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            GetBucketAnalyticsConfigurationResult getBucketAnalyticsConfigurationResult = amazonS3.getBucketAnalyticsConfiguration(request);
            return getBucketAnalyticsConfigurationResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public ListBucketAnalyticsConfigurationsResult listBucketAnalyticsConfigurations(ListBucketAnalyticsConfigurationsRequest request) {
        String function = "listBucketAnalyticsConfigurations";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            ListBucketAnalyticsConfigurationsResult listBucketAnalyticsConfigurationsResult = amazonS3.listBucketAnalyticsConfigurations(request);
            return listBucketAnalyticsConfigurationsResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public SetBucketAnalyticsConfigurationResult setBucketAnalyticsConfiguration(SetBucketAnalyticsConfigurationRequest request) {
        String function = "setBucketAnalyticsConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            SetBucketAnalyticsConfigurationResult setBucketAnalyticsConfigurationResult = amazonS3.setBucketAnalyticsConfiguration(request);
            return setBucketAnalyticsConfigurationResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

